/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import net.n3.nanoxml.XMLElement;

public class XMLWriter {
    private PrintWriter writer;

    public XMLWriter(Writer writer) {
        this.writer = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public XMLWriter(OutputStream outputStream) {
        this.writer = new PrintWriter(outputStream);
    }

    protected void finalize() throws Throwable {
        this.writer = null;
        super.finalize();
    }

    public void write(XMLElement xMLElement) throws IOException {
        this.write(xMLElement, true, 0);
    }

    public void write(XMLElement xMLElement, boolean bl) throws IOException {
        this.write(xMLElement, bl, 0);
    }

    public void write(XMLElement xMLElement, boolean bl, int n) throws IOException {
        if (bl) {
            for (int i = 0; i < n; ++i) {
                this.writer.print(' ');
            }
        }
        if (xMLElement.getName() == null) {
            if (xMLElement.getContent() != null) {
                if (bl) {
                    this.writeEncoded(xMLElement.getContent().trim());
                    this.writer.println();
                } else {
                    this.writeEncoded(xMLElement.getContent());
                }
            }
        } else {
            Object object;
            this.writer.print('<');
            this.writer.print(xMLElement.getName());
            Enumeration enumeration = xMLElement.enumerateAttributeNames();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                String string = xMLElement.getAttribute((String)object);
                this.writer.print(" " + (String)object + "=\"");
                this.writeEncoded(string);
                this.writer.print('\"');
            }
            if (xMLElement.getContent() != null && xMLElement.getContent().length() > 0) {
                this.writer.print('>');
                this.writeEncoded(xMLElement.getContent());
                this.writer.print("</" + xMLElement.getName() + '>');
                if (bl) {
                    this.writer.println();
                }
            } else if (xMLElement.hasChildren()) {
                this.writer.print('>');
                if (bl) {
                    this.writer.println();
                }
                enumeration = xMLElement.enumerateChildren();
                while (enumeration.hasMoreElements()) {
                    object = (XMLElement)enumeration.nextElement();
                    this.write((XMLElement)object, bl, n + 4);
                }
                if (bl) {
                    for (int i = 0; i < n; ++i) {
                        this.writer.print(' ');
                    }
                }
                this.writer.print("</" + xMLElement.getName() + ">");
                if (bl) {
                    this.writer.println();
                }
            } else {
                this.writer.print("/>");
                if (bl) {
                    this.writer.println();
                }
            }
        }
        this.writer.flush();
    }

    private void writeEncoded(String string) {
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    this.writer.print(c);
                    continue block8;
                }
                case '<': {
                    this.writer.print("&lt;");
                    continue block8;
                }
                case '>': {
                    this.writer.print("&gt;");
                    continue block8;
                }
                case '&': {
                    this.writer.print("&amp;");
                    continue block8;
                }
                case '\'': {
                    this.writer.print("&apos;");
                    continue block8;
                }
                case '\"': {
                    this.writer.print("&quot;");
                    continue block8;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        this.writer.print("&#x");
                        this.writer.print(Integer.toString(c, 16));
                        this.writer.print(';');
                        continue block8;
                    }
                    this.writer.print(c);
                }
            }
        }
    }
}

