/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.util.IoHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class VariableSubstitutor
implements Serializable {
    private static final long serialVersionUID = 3907213762447685687L;
    protected transient Properties variables;
    protected boolean bracesRequired = false;
    protected static final int TYPE_PLAIN = 0;
    protected static final int TYPE_JAVA_PROPERTIES = 1;
    protected static final int TYPE_XML = 2;
    protected static final int TYPE_SHELL = 3;
    protected static final int TYPE_AT = 4;
    protected static final int TYPE_JAVA = 5;
    protected static final int TYPE_ANT = 6;
    public static final String PLAIN = "plain";
    protected static final Map<String, Integer> typeNameToConstantMap = new HashMap<String, Integer>();

    public VariableSubstitutor(Properties properties) {
        this.variables = properties;
    }

    public boolean areBracesRequired() {
        return this.bracesRequired;
    }

    public void setBracesRequired(boolean bl) {
        this.bracesRequired = bl;
    }

    public String substitute(String string, String string2) throws IllegalArgumentException {
        if (string == null) {
            return null;
        }
        StringReader stringReader = new StringReader(string);
        StringWriter stringWriter = new StringWriter();
        try {
            this.substitute(stringReader, stringWriter, string2);
        }
        catch (IOException iOException) {
            throw new Error("Unexpected I/O exception when reading/writing memory buffer; nested exception is: " + iOException);
        }
        return stringWriter.getBuffer().toString();
    }

    public int substitute(InputStream inputStream, OutputStream outputStream, String string, String string2) throws IllegalArgumentException, UnsupportedEncodingException, IOException {
        if (string2 == null) {
            int n = this.getTypeConstant(string);
            switch (n) {
                case 1: {
                    string2 = "ISO-8859-1";
                    break;
                }
                case 2: {
                    string2 = "UTF-8";
                }
            }
        }
        InputStreamReader inputStreamReader = string2 != null ? new InputStreamReader(inputStream, string2) : new InputStreamReader(inputStream);
        OutputStreamWriter outputStreamWriter = string2 != null ? new OutputStreamWriter(outputStream, string2) : new OutputStreamWriter(outputStream);
        int n = this.substitute(inputStreamReader, outputStreamWriter, string);
        outputStreamWriter.flush();
        return n;
    }

    public String substitute(InputStream inputStream, String string) throws IllegalArgumentException, UnsupportedEncodingException, IOException {
        String string2 = PLAIN;
        int n = this.getTypeConstant(string);
        switch (n) {
            case 1: {
                string2 = "ISO-8859-1";
                break;
            }
            case 2: {
                string2 = "UTF-8";
            }
        }
        InputStreamReader inputStreamReader = string2 != null ? new InputStreamReader(inputStream, string2) : new InputStreamReader(inputStream);
        StringWriter stringWriter = new StringWriter();
        this.substitute(inputStreamReader, stringWriter, string);
        stringWriter.flush();
        return stringWriter.getBuffer().toString();
    }

    public int substitute(Reader reader, Writer writer, String string) throws IllegalArgumentException, IOException {
        int n;
        int n2 = this.getTypeConstant(string);
        int n3 = 36;
        int n4 = 0;
        if (n2 == 3) {
            n3 = 37;
        } else if (n2 == 4) {
            n3 = 64;
        } else if (n2 == 6) {
            n3 = 64;
            n4 = 64;
        }
        int n5 = 0;
        int n6 = reader.read();
        if (n6 == 239) {
            for (n = 0; n < 2; ++n) {
                n6 = reader.read();
            }
        }
        if (n6 > 255) {
            n6 = reader.read();
        }
        while (true) {
            if (n6 != -1 && n6 != n3) {
                writer.write(n6);
                n6 = reader.read();
                continue;
            }
            if (n6 == -1) {
                return n5;
            }
            n = 0;
            n6 = reader.read();
            if (n6 == 123) {
                n = 1;
                n6 = reader.read();
            } else {
                if (this.bracesRequired) {
                    writer.write(n3);
                    continue;
                }
                if (n6 == -1) {
                    writer.write(n3);
                    return n5;
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            while (n6 != -1 && n != 0 && n6 != 125 || n6 >= 97 && n6 <= 122 || n6 >= 65 && n6 <= 90 || n != 0 && n6 == 91 || n6 == 93 || (n6 >= 48 && n6 <= 57 || n6 == 95 || n6 == 46 || n6 == 45) && stringBuffer.length() > 0) {
                stringBuffer.append((char)n6);
                n6 = reader.read();
            }
            String string2 = stringBuffer.toString();
            String string3 = null;
            if (!(n != 0 && n6 != 125 || n != 0 && n4 != 0 && n4 != n6 || string2.length() <= 0)) {
                string3 = n != 0 && string2.startsWith("ENV[") && string2.lastIndexOf(93) == string2.length() - 1 ? IoHelper.getenv(string2.substring(4, string2.length() - 1)) : this.variables.getProperty(string2);
                ++n5;
            }
            if (string3 != null) {
                writer.write(this.escapeSpecialChars(string3, n2));
                if (n == 0 && n4 == 0) continue;
                n6 = reader.read();
                continue;
            }
            writer.write(n3);
            if (n != 0) {
                writer.write(123);
            }
            writer.write(string2);
        }
    }

    protected int getTypeConstant(String string) {
        if (string == null) {
            return 0;
        }
        Integer n = typeNameToConstantMap.get(string);
        if (n == null) {
            throw new IllegalArgumentException("Unknown file type " + string);
        }
        return n;
    }

    protected String escapeSpecialChars(String string, int n) {
        switch (n) {
            case 0: 
            case 3: 
            case 4: 
            case 6: {
                return string;
            }
            case 1: 
            case 5: {
                StringBuffer stringBuffer = new StringBuffer(string);
                int n2 = string.length();
                for (int i = 0; i < n2; ++i) {
                    char c = stringBuffer.charAt(i);
                    if (n == 1) {
                        if (c == '\t' || c == '\n' || c == '\r') {
                            char c2 = c == '\t' ? (char)'t' : (c == '\n' ? (char)'n' : 'r');
                            stringBuffer.replace(i, i + 1, "\\" + c2);
                            ++n2;
                            ++i;
                        }
                        if (c != '\\' && c != '\"' && c != '\'' && c != ' ') continue;
                        stringBuffer.insert(i, '\\');
                        ++n2;
                        ++i;
                        continue;
                    }
                    if (c != '\\') continue;
                    stringBuffer.replace(i, i + 1, "\\\\");
                    ++n2;
                    ++i;
                }
                return stringBuffer.toString();
            }
            case 2: {
                StringBuffer stringBuffer = new StringBuffer(string);
                int n3 = string.length();
                for (int i = 0; i < n3; ++i) {
                    String string2 = null;
                    char c = stringBuffer.charAt(i);
                    switch (c) {
                        case '<': {
                            string2 = "&lt;";
                            break;
                        }
                        case '>': {
                            string2 = "&gt;";
                            break;
                        }
                        case '&': {
                            string2 = "&amp;";
                            break;
                        }
                        case '\'': {
                            string2 = "&apos;";
                            break;
                        }
                        case '\"': {
                            string2 = "&quot;";
                        }
                    }
                    if (string2 == null) continue;
                    stringBuffer.replace(i, i + 1, string2);
                    n3 = stringBuffer.length();
                    i += string2.length() - 1;
                }
                return stringBuffer.toString();
            }
        }
        throw new Error("Unknown file type constant " + n);
    }

    static {
        typeNameToConstantMap.put(PLAIN, 0);
        typeNameToConstantMap.put("javaprop", 1);
        typeNameToConstantMap.put("java", 5);
        typeNameToConstantMap.put("xml", 2);
        typeNameToConstantMap.put("shell", 3);
        typeNameToConstantMap.put("at", 4);
        typeNameToConstantMap.put("ant", 6);
    }
}

