/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.util.AbstractUIHandler;
import com.izforge.izpack.util.Console;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileUtil;
import com.izforge.izpack.util.MonitorInputStream;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.OsVersion;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileExecutor {
    private static final String JAR_FILE_SUFFIX = ".jar";
    private Collection<ExecutableFile> files;

    private boolean stopThread(Thread thread, MonitorInputStream monitorInputStream) {
        monitorInputStream.doStop();
        long l = 1000L;
        try {
            thread.join(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!thread.isAlive()) {
            return true;
        }
        thread.interrupt();
        long l2 = 1000L;
        try {
            thread.join(l2);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return !thread.isAlive();
    }

    public FileExecutor(Collection<ExecutableFile> collection) {
        this.files = collection;
    }

    public FileExecutor() {
        this.files = null;
    }

    public static String getExecOutput(String[] stringArray) {
        return FileExecutor.getExecOutput(stringArray, false);
    }

    public static String getExecOutput(String[] stringArray, boolean bl) {
        FileExecutor fileExecutor = new FileExecutor();
        String[] stringArray2 = new String[2];
        int n = fileExecutor.executeCommand(stringArray, stringArray2);
        if (n == 0) {
            return stringArray2[0];
        }
        if (bl) {
            return stringArray2[0];
        }
        return stringArray2[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeCommand(String[] stringArray, String[] stringArray2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("executeCommand\n");
        if (stringArray != null) {
            for (String object2 : stringArray) {
                stringBuffer.append("\tparams: ").append(object2);
                stringBuffer.append("\n");
            }
        }
        Object object3 = null;
        MonitorInputStream monitorInputStream = null;
        MonitorInputStream monitorInputStream2 = null;
        Thread thread = null;
        Thread thread2 = null;
        int n = -1;
        Debug.trace(stringBuffer);
        try {
            object3 = Runtime.getRuntime().exec(stringArray);
            boolean iOException = false;
            if (iOException) {
                Console console = new Console((Process)object3);
                stringArray2[0] = console.getOutputData();
                stringArray2[1] = console.getErrorData();
                n = ((Process)object3).exitValue();
            } else {
                StringWriter stringWriter = new StringWriter();
                StringWriter stringWriter2 = new StringWriter();
                InputStreamReader inputStreamReader = new InputStreamReader(((Process)object3).getInputStream());
                InputStreamReader inputStreamReader2 = new InputStreamReader(((Process)object3).getErrorStream());
                monitorInputStream = new MonitorInputStream(inputStreamReader, stringWriter);
                monitorInputStream2 = new MonitorInputStream(inputStreamReader2, stringWriter2);
                Thread thread3 = new Thread(monitorInputStream);
                thread2 = new Thread(monitorInputStream2);
                thread3.setDaemon(true);
                thread2.setDaemon(true);
                thread3.start();
                thread2.start();
                n = ((Process)object3).waitFor();
                thread3.join();
                thread2.join();
                stringArray2[0] = stringWriter.toString();
                Debug.trace("stdout:");
                Debug.trace(stringArray2[0]);
                stringArray2[1] = stringWriter2.toString();
                Debug.trace("stderr:");
                Debug.trace(stringArray2[1]);
            }
            Debug.trace("exit status: " + Integer.toString(n));
        }
        catch (InterruptedException interruptedException) {
            if (Debug.tracing()) {
                interruptedException.printStackTrace(System.err);
            }
            this.stopThread(thread, monitorInputStream);
            this.stopThread(thread2, monitorInputStream2);
            stringArray2[0] = "";
            stringArray2[1] = interruptedException.getMessage() + "\n";
        }
        catch (IOException iOException) {
            if (Debug.tracing()) {
                iOException.printStackTrace(System.err);
            }
            stringArray2[0] = "";
            stringArray2[1] = iOException.getMessage() + "\n";
        }
        finally {
            if (object3 != null) {
                ((Process)object3).destroy();
            }
        }
        return n;
    }

    public int executeFiles(int n, AbstractUIHandler abstractUIHandler) {
        int n2 = 0;
        String[] stringArray = new String[2];
        String string = "a+x";
        Iterator<ExecutableFile> iterator = this.files.iterator();
        while (n2 == 0 && iterator.hasNext()) {
            String[] stringArray2;
            ExecutableFile executableFile = iterator.next();
            boolean bl = !executableFile.keepFile;
            File file = new File(executableFile.path);
            Debug.trace("handling executable file " + executableFile);
            if (!OsConstraint.oneMatchesCurrentSystem(executableFile.osList)) continue;
            if (0 == executableFile.type && n != 2 && OsVersion.IS_UNIX) {
                Debug.trace("making file executable (setting executable flag)");
                stringArray2 = new String[]{"/bin/chmod", string, file.toString()};
                n2 = this.executeCommand(stringArray2, stringArray);
                if (n2 != 0) {
                    abstractUIHandler.emitError("file execution error", "Error executing \n" + stringArray2[0] + " " + stringArray2[1] + " " + stringArray2[2]);
                    continue;
                }
            }
            if (n2 == 0 && (n == 0 && executableFile.executionStage == 0 || n == 2 && executableFile.executionStage == 2)) {
                stringArray2 = new ArrayList();
                if (0 == executableFile.type) {
                    stringArray2.add(file.toString());
                } else if (1 == executableFile.type && null == executableFile.mainClass) {
                    stringArray2.add(System.getProperty("java.home") + "/bin/java");
                    stringArray2.add("-jar");
                    stringArray2.add(file.toString());
                } else if (1 == executableFile.type && null != executableFile.mainClass) {
                    stringArray2.add(System.getProperty("java.home") + "/bin/java");
                    stringArray2.add("-cp");
                    try {
                        stringArray2.add(this.buildClassPath(file.toString()));
                    }
                    catch (Exception exception) {
                        n2 = -1;
                        Debug.error(exception);
                    }
                    stringArray2.add(executableFile.mainClass);
                }
                if (null != executableFile.argList && !executableFile.argList.isEmpty()) {
                    stringArray2.addAll(executableFile.argList);
                }
                String[] stringArray3 = new String[stringArray2.size()];
                for (int i = 0; i < stringArray2.size(); ++i) {
                    stringArray3[i] = (String)stringArray2.get(i);
                }
                n2 = this.executeCommand(stringArray3, stringArray);
                if (n2 != 0) {
                    bl = false;
                    String string2 = stringArray[0] + "\n" + stringArray[1];
                    if (string2.length() == 1) {
                        string2 = "Failed to execute " + file.toString() + ".";
                    }
                    if (executableFile.onFailure == 0) {
                        abstractUIHandler.emitError("file execution error", string2);
                    } else if (executableFile.onFailure == 1) {
                        abstractUIHandler.emitWarning("file execution error", string2);
                        n2 = 0;
                    } else if (executableFile.onFailure == 3) {
                        n2 = 0;
                    } else if (abstractUIHandler.askQuestion("Execution Failed", string2 + "\nContinue Installation?", 37) == 47) {
                        n2 = 0;
                    }
                }
            }
            if (executableFile.executionStage != 0 || !bl || !file.canWrite()) continue;
            file.delete();
        }
        return n2;
    }

    private String buildClassPath(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = string.replace(':', File.pathSeparatorChar).replace(';', File.pathSeparatorChar);
        String[] stringArray = string2.split("" + File.pathSeparatorChar);
        for (String string3 : stringArray) {
            String[] stringArray2;
            File file = new File(string3);
            arrayList.add(string3);
            if (!file.isDirectory() || (stringArray2 = FileUtil.getFileNames(string3, new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.toLowerCase().endsWith(FileExecutor.JAR_FILE_SUFFIX);
                }
            })) == null) continue;
            for (String string4 : stringArray2) {
                arrayList.add(string3 + File.separator + string4);
            }
        }
        Iterator iterator = arrayList.iterator();
        if (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
        }
        while (iterator.hasNext()) {
            stringBuffer.append(File.pathSeparatorChar).append((String)iterator.next());
        }
        return stringBuffer.toString();
    }
}

