/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.Pack;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.ResourceNotFoundException;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.panels.ShortcutData;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.MultiLineLabel;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.StringTool;
import com.izforge.izpack.util.TargetFactory;
import com.izforge.izpack.util.VariableSubstitutor;
import com.izforge.izpack.util.os.Shortcut;
import com.izforge.izpack.util.os.Unix_Shortcut;
import com.izforge.izpack.util.os.unix.UnixHelper;
import com.izforge.izpack.util.xml.XMLHelper;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLBuilderFactory;
import net.n3.nanoxml.XMLElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortcutPanel
extends IzPanel
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 3256722870838112311L;
    public static final String SPEC_ATTRIBUTE_KDE_USERNAME = "KdeUsername";
    public static final String SPEC_ATTRIBUTE_KDE_SUBST_UID = "KdeSubstUID";
    public static final String SPEC_ATTRIBUTE_URL = "url";
    public static final String SPEC_ATTRIBUTE_TYPE = "type";
    public static final String SPEC_ATTRIBUTE_TERMINAL_OPTIONS = "terminalOptions";
    public static final String SPEC_ATTRIBUTE_TERMINAL = "terminal";
    public static final String SPEC_ATTRIBUTE_MIMETYPE = "mimetype";
    public static final String SPEC_ATTRIBUTE_ENCODING = "encoding";
    private static final String LOCATION_APPLICATIONS = "applications";
    private static final String LOCATION_START_MENU = "startMenu";
    public static final String SPEC_CATEGORIES = "categories";
    public static final String SPEC_TRYEXEC = "tryexec";
    private static final String SEPARATOR_LINE = "--------------------------------------------------------------------------------";
    private static final String TEXT_FILE_NAME = "Shortcuts.txt";
    private static final String SPEC_FILE_NAME = "shortcutSpec.xml";
    private static final String SPEC_KEY_SKIP_IFNOT_SUPPORTED = "skipIfNotSupported";
    private static final String SPEC_KEY_NOT_SUPPORTED = "notSupported";
    private static final String SPEC_KEY_PROGRAM_GROUP = "programGroup";
    private static final String SPEC_KEY_SHORTCUT = "shortcut";
    private static final String SPEC_KEY_PACKS = "createForPack";
    private static final String SPEC_ATTRIBUTE_DEFAULT_GROUP = "defaultName";
    private static final String SPEC_ATTRIBUTE_INSTALLGROUP = "installGroup";
    private static final String SPEC_ATTRIBUTE_LOCATION = "location";
    private static final String SPEC_ATTRIBUTE_NAME = "name";
    private static final String SPEC_ATTRIBUTE_SUBGROUP = "subgroup";
    private static final String SPEC_ATTRIBUTE_DESCRIPTION = "description";
    private static final String SPEC_ATTRIBUTE_TARGET = "target";
    private static final String SPEC_ATTRIBUTE_COMMAND = "commandLine";
    private static final String SPEC_ATTRIBUTE_ICON = "iconFile";
    private static final String SPEC_ATTRIBUTE_ICON_INDEX = "iconIndex";
    private static final String SPEC_ATTRIBUTE_WORKING_DIR = "workingDirectory";
    private static final String SPEC_ATTRIBUTE_INITIAL_STATE = "initialState";
    private static final String SPEC_ATTRIBUTE_DESKTOP = "desktop";
    private static final String SPEC_ATTRIBUTE_APPLICATIONS = "applications";
    private static final String SPEC_ATTRIBUTE_START_MENU = "startMenu";
    private static final String SPEC_ATTRIBUTE_STARTUP = "startup";
    private static final String SPEC_ATTRIBUTE_PROGRAM_GROUP = "programGroup";
    private static final String SPEC_VALUE_APPLICATIONS = "applications";
    private static final String SPEC_VALUE_START_MENU = "startMenu";
    private static final String SPEC_VALUE_NO_SHOW = "noShow";
    private static final String SPEC_VALUE_NORMAL = "normal";
    private static final String SPEC_VALUE_MAXIMIZED = "maximized";
    private static final String SPEC_VALUE_MINIMIZED = "minimized";
    public static final String AUTO_KEY_PROGRAM_GROUP = "programGroup";
    public static final String AUTO_KEY_SHORTCUT = "shortcut";
    public static final String AUTO_ATTRIBUTE_NAME = "name";
    public static final String AUTO_ATTRIBUTE_GROUP = "group";
    public static final String AUTO_ATTRIBUTE_TYPE = "type";
    public static final String AUTO_ATTRIBUTE_COMMAND = "commandLine";
    public static final String AUTO_ATTRIBUTE_DESCRIPTION = "description";
    public static final String AUTO_ATTRIBUTE_ICON = "icon";
    public static final String AUTO_ATTRIBUTE_ICON_INDEX = "iconIndex";
    public static final String AUTO_ATTRIBUTE_INITIAL_STATE = "initialState";
    public static final String AUTO_ATTRIBUTE_TARGET = "target";
    public static final String AUTO_ATTRIBUTE_WORKING_DIR = "workingDirectory";
    public static final String CREATE_FOR_ALL = "createForAll";
    private static ShortcutPanel self = null;
    private static boolean firstTime = true;
    static boolean create;
    public static boolean createImmediately;
    private static boolean isRootUser;
    private Vector<ExecutableFile> execFiles = new Vector();
    private JLabel listLabel;
    private JList groupList;
    private JList targetList;
    private JTextField programGroup;
    private JButton defaultButton;
    private JButton saveButton;
    private JCheckBox allowDesktopShortcut;
    private JCheckBox createShortcuts;
    private JRadioButton currentUser;
    private JRadioButton allUsers;
    private GridBagLayout layout;
    private GridBagConstraints constraints;
    private String suggestedProgramGroup;
    private String groupName;
    private String programGroupIconFile;
    private String programGroupComment;
    private int groupLocation;
    private XMLElement spec;
    private boolean hasDesktopShortcuts = false;
    private boolean skipIfNotSupported = false;
    private Shortcut shortcut;
    private Vector shortcuts = new Vector();
    private Vector<String> files = new Vector();
    private boolean shortcutsToCreate = false;
    private boolean haveShortcutSpec = false;
    private boolean simulteNotSupported = false;
    private File itsProgramFolder;
    private int itsUserType;
    public static final String USER_TYPE = "usertype";
    private Vector<String> shortCuts;
    int line;
    int col;

    public ShortcutPanel(InstallerFrame installerFrame, InstallData installData) {
        super(installerFrame, installData, "link16x16");
        this.layout = (GridBagLayout)super.getLayout();
        Object object = this.getLayoutHelper().getDefaultConstraints();
        if (object instanceof GridBagConstraints) {
            this.constraints = (GridBagConstraints)object;
        } else {
            object = new GridBagConstraints();
        }
        this.setLayout(super.getLayout());
        if (self != null) {
            throw new RuntimeException(this.getClass().getName() + " is not allowed to instantiate more than once!");
        }
        self = this;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.currentUser)) {
            if (this.groupList != null) {
                this.groupList.setListData(this.shortcut.getProgramGroups(1));
            }
            this.programGroup.setText(this.suggestedProgramGroup);
            this.itsUserType = 1;
            this.shortcut.setUserType(1);
        } else if (object.equals(this.allUsers)) {
            if (this.groupList != null) {
                this.groupList.setListData(this.shortcut.getProgramGroups(2));
            }
            this.programGroup.setText(this.suggestedProgramGroup);
            this.itsUserType = 2;
            this.shortcut.setUserType(2);
        } else if (object.equals(this.defaultButton)) {
            if (this.groupList != null && this.groupList.getSelectionModel() != null) {
                this.groupList.getSelectionModel().clearSelection();
            }
            this.programGroup.setText(this.suggestedProgramGroup);
        } else if (object.equals(this.saveButton)) {
            this.saveToFile();
            this.addToUninstaller();
        } else if (object.equals(this.createShortcuts)) {
            create = this.createShortcuts.isSelected();
            if (this.groupList != null) {
                this.groupList.setEnabled(create);
            }
            this.programGroup.setEnabled(create);
            this.currentUser.setEnabled(create);
            this.defaultButton.setEnabled(create);
            if (this.allowDesktopShortcut != null) {
                this.allowDesktopShortcut.setEnabled(create);
            }
            if (isRootUser) {
                this.allUsers.setEnabled(create);
            }
        }
    }

    @Override
    public boolean isValidated() {
        try {
            this.groupName = this.programGroup.getText();
        }
        catch (Throwable throwable) {
            this.groupName = "";
        }
        create = this.createShortcuts.isSelected();
        if (createImmediately) {
            this.createAndRegisterShortcuts();
        }
        return true;
    }

    @Override
    public void panelActivate() {
        try {
            this.readShortcutSpec();
        }
        catch (Throwable throwable) {
            System.out.println("could not read shortcut spec!");
            throwable.printStackTrace();
        }
        try {
            this.shortcut = (Shortcut)TargetFactory.getInstance().makeObject("com.izforge.izpack.util.os.Shortcut");
            this.shortcut.initialize(1, "-");
        }
        catch (Throwable throwable) {
            System.out.println("could not create shortcut instance");
            throwable.printStackTrace();
        }
        this.analyzeShortcutSpec();
        if (this.shortcutsToCreate && !OsVersion.IS_OSX) {
            if (this.shortcut.supported() && !this.simulteNotSupported) {
                File file = this.getProgramsFolder(2);
                Debug.log("All UsersProgramsFolder: '" + file + "'");
                File file2 = new File(file + File.separator + System.getProperty("user.name") + System.currentTimeMillis());
                try {
                    isRootUser = file2.createNewFile();
                }
                catch (Exception exception) {
                    isRootUser = false;
                    Debug.log("IOException: '" + exception.getLocalizedMessage() + "'");
                    Debug.log("You cannot create '" + file2 + "'");
                }
                if (file2.exists()) {
                    Debug.log("Delete temporary File: '" + file2 + "'");
                    file2.delete();
                }
                String string = isRootUser ? "can" : "cannot";
                Debug.log("You " + string + " write into '" + file + "'");
                this.itsUserType = isRootUser ? 2 : 1;
                if (firstTime) {
                    this.buildUI(this.getProgramsFolder(isRootUser ? 2 : 1));
                }
            } else if (firstTime) {
                this.buildAlternateUI();
            }
            firstTime = false;
        } else {
            this.parent.skipPanel();
        }
    }

    private File getProgramsFolder(int n) {
        String string = this.shortcut.getProgramsFolder(n);
        return new File(string);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.programGroup == null) {
            return;
        }
        String string = "";
        try {
            string = (String)this.groupList.getSelectedValue();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (string == null) {
            string = "";
        }
        this.programGroup.setText(string + File.separator + this.suggestedProgramGroup);
    }

    private void readShortcutSpec() throws Exception {
        InputStream inputStream = null;
        try {
            inputStream = ResourceManager.getInstance().getInputStream(TargetFactory.getCurrentOSPrefix() + SPEC_FILE_NAME);
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            inputStream = ResourceManager.getInstance().getInputStream(SPEC_FILE_NAME);
        }
        if (inputStream == null) {
            this.haveShortcutSpec = false;
            return;
        }
        VariableSubstitutor variableSubstitutor = new VariableSubstitutor(this.idata.getVariables());
        String string = variableSubstitutor.substitute(inputStream, "xml");
        StdXMLParser stdXMLParser = new StdXMLParser();
        stdXMLParser.setBuilder(XMLBuilderFactory.createXMLBuilder());
        stdXMLParser.setValidator(new NonValidator());
        stdXMLParser.setReader(StdXMLReader.stringReader(string));
        this.spec = (XMLElement)stdXMLParser.parse();
        inputStream.close();
        this.haveShortcutSpec = true;
    }

    private void analyzeShortcutSpec() {
        Object object;
        if (!this.haveShortcutSpec) {
            this.shortcutsToCreate = false;
            return;
        }
        XMLElement xMLElement = this.spec.getFirstChildNamed(SPEC_KEY_SKIP_IFNOT_SUPPORTED);
        this.skipIfNotSupported = xMLElement != null;
        XMLElement xMLElement2 = this.spec.getFirstChildNamed(SPEC_KEY_NOT_SUPPORTED);
        if (xMLElement2 != null) {
            this.simulteNotSupported = true;
        }
        XMLElement xMLElement3 = null;
        Vector<XMLElement> vector = this.spec.getChildrenNamed("programGroup");
        String string = this.idata.getVariable("INSTALL_GROUP");
        if (string != null) {
            for (XMLElement serializable2 : vector) {
                object = serializable2.getAttribute(SPEC_ATTRIBUTE_INSTALLGROUP);
                if (object == null || !string.equalsIgnoreCase((String)object)) continue;
                xMLElement3 = serializable2;
                break;
            }
        }
        if (xMLElement3 == null) {
            xMLElement3 = this.spec.getFirstChildNamed("programGroup");
        }
        Object object2 = null;
        this.hasDesktopShortcuts = false;
        if (xMLElement3 != null) {
            this.suggestedProgramGroup = xMLElement3.getAttribute(SPEC_ATTRIBUTE_DEFAULT_GROUP, "");
            this.programGroupIconFile = xMLElement3.getAttribute(SPEC_ATTRIBUTE_ICON, "");
            this.programGroupComment = xMLElement3.getAttribute("comment", "");
            object2 = xMLElement3.getAttribute(SPEC_ATTRIBUTE_LOCATION, "applications");
        } else {
            this.suggestedProgramGroup = "";
            object2 = "applications";
        }
        if (((String)object2).equals("applications")) {
            this.groupLocation = 1;
        } else if (((String)object2).equals("startMenu")) {
            this.groupLocation = 2;
        }
        Vector<XMLElement> vector2 = this.spec.getChildrenNamed("shortcut");
        this.shortCuts = new Vector();
        for (int i = 0; i < vector2.size(); ++i) {
            Vector<XMLElement> vector3;
            object = vector2.elementAt(i);
            if (!OsConstraint.oneMatchesCurrentSystem((XMLElement)object)) continue;
            Debug.log("Checking Condition for " + ((XMLElement)object).getAttribute("name"));
            if (!this.checkConditions((XMLElement)object)) continue;
            Debug.log("Checked Condition for " + ((XMLElement)object).getAttribute("name"));
            ShortcutData shortcutData = new ShortcutData();
            shortcutData.name = ((XMLElement)object).getAttribute("name");
            shortcutData.subgroup = ((XMLElement)object).getAttribute(SPEC_ATTRIBUTE_SUBGROUP, "");
            shortcutData.description = ((XMLElement)object).getAttribute("description", "");
            shortcutData.deskTopEntryLinux_Encoding = ((XMLElement)object).getAttribute(SPEC_ATTRIBUTE_ENCODING, "");
            shortcutData.deskTopEntryLinux_MimeType = ((XMLElement)object).getAttribute(SPEC_ATTRIBUTE_MIMETYPE, "");
            shortcutData.deskTopEntryLinux_Terminal = ((XMLElement)object).getAttribute(SPEC_ATTRIBUTE_TERMINAL, "");
            shortcutData.deskTopEntryLinux_TerminalOptions = ((XMLElement)object).getAttribute(SPEC_ATTRIBUTE_TERMINAL_OPTIONS, "");
            shortcutData.deskTopEntryLinux_Type = ((XMLElement)object).getAttribute("type", "");
            shortcutData.deskTopEntryLinux_URL = ((XMLElement)object).getAttribute(SPEC_ATTRIBUTE_URL, "");
            shortcutData.deskTopEntryLinux_X_KDE_SubstituteUID = ((XMLElement)object).getAttribute(SPEC_ATTRIBUTE_KDE_SUBST_UID, "false");
            shortcutData.deskTopEntryLinux_X_KDE_UserName = ((XMLElement)object).getAttribute(SPEC_ATTRIBUTE_KDE_USERNAME, "root");
            shortcutData.Categories = ((XMLElement)object).getAttribute(SPEC_CATEGORIES, "Application;Development");
            shortcutData.TryExec = ((XMLElement)object).getAttribute(SPEC_TRYEXEC, "");
            shortcutData.createForAll = Boolean.valueOf(((XMLElement)object).getAttribute(CREATE_FOR_ALL, "false"));
            shortcutData.target = this.fixSeparatorChar(((XMLElement)object).getAttribute("target", ""));
            shortcutData.commandLine = ((XMLElement)object).getAttribute("commandLine", "");
            shortcutData.iconFile = this.fixSeparatorChar(((XMLElement)object).getAttribute(SPEC_ATTRIBUTE_ICON, ""));
            shortcutData.iconIndex = Integer.parseInt(((XMLElement)object).getAttribute("iconIndex", "0"));
            shortcutData.workingDirectory = this.fixSeparatorChar(((XMLElement)object).getAttribute("workingDirectory", ""));
            String string2 = ((XMLElement)object).getAttribute("initialState", "");
            shortcutData.initialState = string2.equals(SPEC_VALUE_NO_SHOW) ? 0 : (string2.equals(SPEC_VALUE_NORMAL) ? 1 : (string2.equals(SPEC_VALUE_MAXIMIZED) ? 3 : (string2.equals(SPEC_VALUE_MINIMIZED) ? 2 : 1)));
            if (shortcutData.name == null) continue;
            if (shortcutData.target == null) {
                shortcutData.target = "";
            }
            if (!this.shortcutRequiredFor(vector3 = ((XMLElement)object).getChildrenNamed(SPEC_KEY_PACKS))) continue;
            if (XMLHelper.attributeIsTrue((XMLElement)object, SPEC_ATTRIBUTE_DESKTOP)) {
                this.hasDesktopShortcuts = true;
                shortcutData.addToGroup = false;
                shortcutData.type = 3;
                this.shortcuts.add(shortcutData.clone());
            }
            if (XMLHelper.attributeIsTrue((XMLElement)object, "applications")) {
                shortcutData.addToGroup = false;
                shortcutData.type = 1;
                this.shortcuts.add(shortcutData.clone());
            }
            if (XMLHelper.attributeIsTrue((XMLElement)object, "startMenu")) {
                shortcutData.addToGroup = false;
                shortcutData.type = 2;
                this.shortcuts.add(shortcutData.clone());
            }
            if (XMLHelper.attributeIsTrue((XMLElement)object, SPEC_ATTRIBUTE_STARTUP)) {
                shortcutData.addToGroup = false;
                shortcutData.type = 4;
                this.shortcuts.add(shortcutData.clone());
            }
            if (XMLHelper.attributeIsTrue((XMLElement)object, "programGroup")) {
                shortcutData.addToGroup = true;
                shortcutData.type = 1;
                this.shortcuts.add(shortcutData.clone());
            }
            this.shortCuts.add(shortcutData.name == null ? "" : shortcutData.name);
        }
        if (this.shortcuts.size() > 0) {
            this.shortcutsToCreate = true;
        }
    }

    private boolean checkConditions(XMLElement xMLElement) {
        return true;
    }

    public void createAndRegisterShortcuts() {
        this.createShortcuts();
        this.addToUninstaller();
    }

    private String createXDGMenu(ArrayList arrayList, String string) {
        String string2 = "<Menu>\n<Name>Applications</Name>\n<Menu>\n<Directory>" + string.replaceAll(" ", "-") + "-izpack.directory</Directory>\n" + "<Name>" + string + "</Name>\n" + "<Include>\n";
        for (Object e : arrayList) {
            String string3 = (String)e;
            string2 = string2 + "<Filename>" + string3 + "</Filename>\n";
        }
        string2 = string2 + "</Include>\n</Menu>\n</Menu>";
        return string2;
    }

    private String createXDGDirectory(String string, String string2, String string3) {
        String string4 = "[Desktop Entry]\nName=$Name\nComment=$Comment\nIcon=$Icon\nType=Directory\nEncoding=UTF-8";
        string4 = StringTool.replace(string4, "$Name", string);
        string4 = StringTool.replace(string4, "$Comment", string3);
        string4 = StringTool.replace(string4, "$Icon", string2);
        return string4;
    }

    private void writeXDGMenuFile(ArrayList arrayList, String string, String string2, String string3) {
        if ("".equals(this.suggestedProgramGroup) || this.suggestedProgramGroup == null) {
            return;
        }
        if (OsVersion.IS_UNIX) {
            String string4;
            String string5;
            String string6 = this.createXDGMenu(arrayList, string);
            String string7 = this.createXDGDirectory(string, string2, string3);
            if (this.itsUserType == 2) {
                string5 = "/etc/xdg/menus/applications-merged/";
                string4 = "/usr/share/desktop-directories/";
            } else {
                string5 = System.getProperty("user.home") + File.separator + ".config/menus/applications-merged/";
                string4 = System.getProperty("user.home") + File.separator + ".local/share/desktop-directories/";
            }
            File file = new File(string5);
            File file2 = new File(string4);
            String string8 = string5 + string + ".menu";
            String string9 = string4 + string.replaceAll(" ", "-") + "-izpack.directory";
            file.mkdirs();
            file2.mkdirs();
            this.writeString(string6, string8);
            this.writeString(string7, string9);
        }
    }

    private void writeString(String string, String string2) {
        boolean bl = false;
        try {
            FileWriter fileWriter = new FileWriter(string2);
            fileWriter.write(string);
            fileWriter.close();
        }
        catch (Exception exception) {
            bl = true;
            Debug.log("Failed to create menu for gnome.");
        }
        if (!bl) {
            UninstallData.getInstance().addFile(string2, true);
        }
    }

    private void createShortcuts() {
        if (!create) {
            Debug.log(this.getClass().getName() + "::createShortcuts():create=" + create);
            return;
        }
        String string = this.groupName;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.shortcuts.size(); ++i) {
            ShortcutData shortcutData = (ShortcutData)this.shortcuts.elementAt(i);
            try {
                string = this.groupName + shortcutData.subgroup;
                this.shortcut.setUserType(this.itsUserType);
                this.shortcut.setLinkName(shortcutData.name);
                this.shortcut.setLinkType(shortcutData.type);
                this.shortcut.setArguments(shortcutData.commandLine);
                this.shortcut.setDescription(shortcutData.description);
                this.shortcut.setIconLocation(shortcutData.iconFile, shortcutData.iconIndex);
                this.shortcut.setShowCommand(shortcutData.initialState);
                this.shortcut.setTargetPath(shortcutData.target);
                this.shortcut.setWorkingDirectory(shortcutData.workingDirectory);
                this.shortcut.setEncoding(shortcutData.deskTopEntryLinux_Encoding);
                this.shortcut.setMimetype(shortcutData.deskTopEntryLinux_MimeType);
                this.shortcut.setTerminal(shortcutData.deskTopEntryLinux_Terminal);
                this.shortcut.setTerminalOptions(shortcutData.deskTopEntryLinux_TerminalOptions);
                this.shortcut.setType(shortcutData.deskTopEntryLinux_Type);
                this.shortcut.setKdeSubstUID(shortcutData.deskTopEntryLinux_X_KDE_SubstituteUID);
                this.shortcut.setKdeUserName(shortcutData.deskTopEntryLinux_X_KDE_UserName);
                this.shortcut.setURL(shortcutData.deskTopEntryLinux_URL);
                this.shortcut.setTryExec(shortcutData.TryExec);
                this.shortcut.setCategories(shortcutData.Categories);
                this.shortcut.setCreateForAll(shortcutData.createForAll);
                this.shortcut.setUninstaller(UninstallData.getInstance());
                if (shortcutData.addToGroup) {
                    this.shortcut.setProgramGroup(string);
                } else {
                    this.shortcut.setProgramGroup("");
                }
                try {
                    Object object;
                    Object object2;
                    if (shortcutData.type == 3 && (shortcutData.type != 3 || !this.allowDesktopShortcut.isSelected())) continue;
                    this.shortcut.save();
                    if ((shortcutData.type == 1 || shortcutData.addToGroup) && this.shortcut instanceof Unix_Shortcut && (object2 = ((Unix_Shortcut)(object = (Unix_Shortcut)this.shortcut)).getWrittenFileName()) != null) {
                        arrayList.add((String)object2);
                    }
                    object = this.shortcut.getFileName();
                    this.files.add(0, (String)object);
                    object2 = new File((String)object);
                    File file = new File(this.shortcut.getBasePath());
                    Vector<Object> vector = new Vector<Object>();
                    this.execFiles.add(new ExecutableFile((String)object, 2, 3, new ArrayList<OsConstraint>(), false));
                    this.files.add((String)object);
                    while ((object2 = ((File)object2).getParentFile()) != null && !((File)object2).equals(file)) {
                        vector.add(object2);
                    }
                    if (object2 == null) continue;
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        this.files.add(0, ((File)enumeration.nextElement()).toString());
                    }
                    continue;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (OsVersion.IS_UNIX) {
            this.writeXDGMenuFile(arrayList, this.groupName, this.programGroupIconFile, this.programGroupComment);
        }
        this.shortcut.execPostAction();
        try {
            if (this.execFiles != null) {
                FileExecutor fileExecutor = new FileExecutor(this.execFiles);
            }
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
        this.shortcut.cleanUp();
    }

    private boolean shortcutRequiredFor(Vector<XMLElement> vector) {
        if (vector.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.idata.selectedPacks.size(); ++i) {
            String string = ((Pack)this.idata.selectedPacks.get((int)i)).name;
            for (int j = 0; j < vector.size(); ++j) {
                String string2 = vector.elementAt(j).getAttribute("name", "");
                if (!string.equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    private String fixSeparatorChar(String string) {
        String string2 = string.replace('/', File.separatorChar);
        string2 = string2.replace('\\', File.separatorChar);
        return string2;
    }

    private void buildUI(File file) {
        Object object;
        this.constraints.insets = new Insets(10, 10, 0, 0);
        String string = this.parent.langpack.getString("ShortcutPanel.regular.StartMenu:Start-Menu");
        if (OsVersion.IS_UNIX && UnixHelper.kdeIsInstalled()) {
            string = this.parent.langpack.getString("ShortcutPanel.regular.StartMenu:K-Menu");
        }
        this.createShortcuts = new JCheckBox(StringTool.replace(this.parent.langpack.getString("ShortcutPanel.regular.create"), "StartMenu", string), true);
        this.createShortcuts.addActionListener(this);
        this.constraints.gridx = this.col;
        this.constraints.gridy = this.line + 1;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.fill = 2;
        this.constraints.anchor = 18;
        this.layout.addLayoutComponent(this.createShortcuts, this.constraints);
        this.add(this.createShortcuts);
        this.constraints.insets = new Insets(0, 10, 0, 0);
        if (this.hasDesktopShortcuts) {
            object = this.idata.getVariable("DesktopShortcutCheckboxEnabled");
            boolean bl = false;
            if (object == null) {
                bl = false;
            } else if (Boolean.TRUE.toString().equals(object)) {
                bl = true;
            }
            this.allowDesktopShortcut = new JCheckBox(this.parent.langpack.getString("ShortcutPanel.regular.desktop"), bl);
            this.constraints.gridx = this.col;
            this.constraints.gridy = this.line + 2;
            this.constraints.gridwidth = 1;
            this.constraints.gridheight = 1;
            this.layout.addLayoutComponent(this.allowDesktopShortcut, this.constraints);
            this.add(this.allowDesktopShortcut);
        }
        this.listLabel = LabelFactory.create(this.parent.langpack.getString("ShortcutPanel.regular.list"), 10);
        if (OsVersion.IS_WINDOWS) {
            this.constraints.gridx = this.col;
            this.constraints.gridy = this.line + 3;
            this.constraints.gridwidth = 1;
            this.constraints.gridheight = 1;
            this.constraints.insets = new Insets(10, 10, 0, 0);
            this.constraints.fill = 2;
            this.constraints.anchor = 18;
        } else {
            this.constraints.gridx = this.col;
            this.constraints.gridy = this.line + 4;
            this.constraints.gridwidth = 1;
            this.constraints.gridheight = 1;
            this.constraints.insets = new Insets(10, 10, 0, 0);
            this.constraints.fill = 2;
            this.constraints.anchor = 16;
        }
        this.layout.addLayoutComponent(this.listLabel, this.constraints);
        this.add(this.listLabel);
        object = new Vector();
        File[] fileArray = file.listFiles();
        if (fileArray != null && !OsVersion.IS_UNIX) {
            for (File file2 : fileArray) {
                if (!file2.isDirectory()) continue;
                ((Vector)object).add(file2.getName());
            }
        }
        if (OsVersion.IS_WINDOWS) {
            if (this.groupList == null) {
                this.groupList = new JList();
            }
            this.groupList = this.addList((Vector<String>)object, 0, this.groupList, this.col, this.line + 4, 1, 1, 1);
        }
        if (this.shortcut.multipleUsers()) {
            JPanel jPanel = new JPanel(new GridLayout(2, 1));
            ButtonGroup buttonGroup = new ButtonGroup();
            this.currentUser = new JRadioButton(this.parent.langpack.getString("ShortcutPanel.regular.currentUser"), !isRootUser);
            this.currentUser.addActionListener(this);
            buttonGroup.add(this.currentUser);
            jPanel.add(this.currentUser);
            this.allUsers = new JRadioButton(this.parent.langpack.getString("ShortcutPanel.regular.allUsers"), isRootUser);
            Debug.log("allUsers.setEnabled(), I'm Root: " + isRootUser);
            this.allUsers.setEnabled(isRootUser);
            this.allUsers.addActionListener(this);
            buttonGroup.add(this.allUsers);
            jPanel.add(this.allUsers);
            TitledBorder titledBorder = new TitledBorder(new EmptyBorder(2, 2, 2, 2), this.parent.langpack.getString("ShortcutPanel.regular.userIntro"));
            jPanel.setBorder(titledBorder);
            if (OsVersion.IS_WINDOWS) {
                this.constraints.gridx = this.col + 1;
                this.constraints.gridy = this.line + 4;
                this.constraints.gridwidth = 1;
                this.constraints.gridheight = 1;
            } else {
                this.constraints.insets = new Insets(10, 10, 20, 0);
                this.constraints.gridx = this.col;
                this.constraints.gridy = this.line + 4;
                this.constraints.gridwidth = 2;
                this.constraints.gridheight = 1;
                this.constraints.anchor = 13;
            }
            this.constraints.fill = 2;
            this.layout.addLayoutComponent(jPanel, this.constraints);
            this.add(jPanel);
        }
        this.programGroup = new JTextField(this.suggestedProgramGroup, 40);
        this.constraints.gridx = this.col;
        this.constraints.gridy = this.line + 5;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.fill = 2;
        this.layout.addLayoutComponent(this.programGroup, this.constraints);
        this.add(this.programGroup);
        this.defaultButton = ButtonFactory.createButton(this.parent.langpack.getString("ShortcutPanel.regular.default"), this.idata.buttonsHColor);
        this.defaultButton.addActionListener(this);
        this.constraints.gridx = this.col + 1;
        this.constraints.gridy = this.line + 5;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.fill = 2;
        this.layout.addLayoutComponent(this.defaultButton, this.constraints);
        this.add(this.defaultButton);
        if (this.suggestedProgramGroup == null || "".equals(this.suggestedProgramGroup)) {
            this.programGroup.setVisible(false);
            this.defaultButton.setVisible(false);
            this.listLabel.setVisible(false);
        }
    }

    private JList addList(Vector<String> vector, int n, JList jList, int n2, int n3, int n4, int n5, int n6) {
        if (jList == null) {
            jList = new JList<String>(vector);
        } else {
            jList.setListData(vector);
        }
        jList.setSelectionMode(n);
        jList.getSelectionModel().addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(jList);
        this.constraints.gridx = n2;
        this.constraints.gridy = n3;
        this.constraints.gridwidth = n4;
        this.constraints.gridheight = n5;
        this.constraints.weightx = 2.0;
        this.constraints.weighty = 1.5;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.constraints.fill = n6;
        this.layout.addLayoutComponent(jScrollPane, this.constraints);
        this.add(jScrollPane);
        return jList;
    }

    private void buildAlternateUI() {
        this.layout = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.setLayout(this.layout);
        MultiLineLabel multiLineLabel = new MultiLineLabel(this.parent.langpack.getString("ShortcutPanel.alternate.apology"), 0, 0);
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.constraints.fill = 2;
        this.constraints.anchor = 17;
        this.layout.addLayoutComponent(multiLineLabel, this.constraints);
        this.add(multiLineLabel);
        MultiLineLabel multiLineLabel2 = new MultiLineLabel(this.parent.langpack.getString("ShortcutPanel.alternate.targetsLabel"), 0, 0);
        this.constraints.gridx = 0;
        this.constraints.gridy = 1;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.layout.addLayoutComponent(multiLineLabel2, this.constraints);
        this.add(multiLineLabel2);
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.shortcuts.size(); ++i) {
            vector.add(((ShortcutData)this.shortcuts.elementAt((int)i)).target);
        }
        this.targetList = new JList(vector);
        JScrollPane jScrollPane = new JScrollPane(this.targetList);
        this.constraints.gridx = 0;
        this.constraints.gridy = 2;
        this.constraints.fill = 1;
        this.layout.addLayoutComponent(jScrollPane, this.constraints);
        this.add(jScrollPane);
        MultiLineLabel multiLineLabel3 = new MultiLineLabel(this.parent.langpack.getString("ShortcutPanel.alternate.textFileExplanation"), 0, 0);
        this.constraints.gridx = 0;
        this.constraints.gridy = 3;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.fill = 2;
        this.layout.addLayoutComponent(multiLineLabel3, this.constraints);
        this.add(multiLineLabel3);
        this.saveButton = ButtonFactory.createButton(this.parent.langpack.getString("ShortcutPanel.alternate.saveButton"), this.idata.buttonsHColor);
        this.saveButton.addActionListener(this);
        this.constraints.gridx = 0;
        this.constraints.gridy = 4;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.layout.addLayoutComponent(this.saveButton, this.constraints);
        this.add(this.saveButton);
    }

    @Override
    public Dimension getSize() {
        Dimension dimension = this.getParent().getSize();
        Insets insets = this.getInsets();
        Border border = this.getBorder();
        Insets insets2 = new Insets(0, 0, 0, 0);
        if (border != null) {
            insets2 = border.getBorderInsets(this);
        }
        dimension.height = dimension.height - insets.top - insets.bottom - insets2.top - insets2.bottom - 50;
        dimension.width = dimension.width - insets.left - insets.right - insets2.left - insets2.right - 50;
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile() {
        File file = null;
        JFileChooser jFileChooser = new JFileChooser(this.idata.getInstallPath());
        jFileChooser.setSelectedFile(new File(TEXT_FILE_NAME));
        if (jFileChooser.showSaveDialog(this) != 0) {
            return;
        }
        file = jFileChooser.getSelectedFile();
        FileWriter fileWriter = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.parent.langpack.getString("ShortcutPanel.textFile.header");
        String string2 = System.getProperty("line.separator", "\n");
        try {
            fileWriter = new FileWriter(file);
        }
        catch (Throwable throwable) {
            return;
        }
        int n = 0;
        int n2 = 0;
        do {
            if ((n = string.indexOf("\\n", n2)) > -1) {
                stringBuffer.append(string.substring(n2, n));
                stringBuffer.append(string2);
                n2 = n + 2;
                continue;
            }
            stringBuffer.append(string.substring(n2, string.length()));
            stringBuffer.append(string2);
        } while (n > -1);
        stringBuffer.append(SEPARATOR_LINE);
        stringBuffer.append(string2);
        stringBuffer.append(string2);
        for (int i = 0; i < this.shortcuts.size(); ++i) {
            ShortcutData shortcutData = (ShortcutData)this.shortcuts.elementAt(i);
            stringBuffer.append(this.parent.langpack.getString("ShortcutPanel.textFile.name"));
            stringBuffer.append(shortcutData.name);
            stringBuffer.append(string2);
            stringBuffer.append(this.parent.langpack.getString("ShortcutPanel.textFile.location"));
            switch (shortcutData.type) {
                case 3: {
                    stringBuffer.append(this.parent.langpack.getString("ShortcutPanel.location.desktop"));
                    break;
                }
                case 1: {
                    stringBuffer.append(this.parent.langpack.getString("ShortcutPanel.location.applications"));
                    break;
                }
                case 2: {
                    stringBuffer.append(this.parent.langpack.getString("ShortcutPanel.location.startMenu"));
                    break;
                }
                case 4: {
                    stringBuffer.append(this.parent.langpack.getString("ShortcutPanel.location.startup"));
                }
            }
            stringBuffer.append(string2);
            stringBuffer.append(this.parent.langpack.getString("ShortcutPanel.textFile.description"));
            stringBuffer.append(shortcutData.description);
            stringBuffer.append(string2);
            stringBuffer.append(this.parent.langpack.getString("ShortcutPanel.textFile.target"));
            stringBuffer.append(shortcutData.target);
            stringBuffer.append(string2);
            stringBuffer.append(this.parent.langpack.getString("ShortcutPanel.textFile.command"));
            stringBuffer.append(shortcutData.commandLine);
            stringBuffer.append(string2);
            stringBuffer.append(this.parent.langpack.getString("ShortcutPanel.textFile.iconName"));
            stringBuffer.append(shortcutData.iconFile);
            stringBuffer.append(string2);
            stringBuffer.append(this.parent.langpack.getString("ShortcutPanel.textFile.iconIndex"));
            stringBuffer.append(shortcutData.iconIndex);
            stringBuffer.append(string2);
            stringBuffer.append(this.parent.langpack.getString("ShortcutPanel.textFile.work"));
            stringBuffer.append(shortcutData.workingDirectory);
            stringBuffer.append(string2);
            stringBuffer.append(string2);
            stringBuffer.append(SEPARATOR_LINE);
            stringBuffer.append(string2);
            stringBuffer.append(string2);
        }
        try {
            fileWriter.write(stringBuffer.toString());
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                fileWriter.flush();
                fileWriter.close();
                this.files.add(file.getPath());
            }
            catch (Throwable throwable) {}
        }
    }

    private void addToUninstaller() {
        UninstallData uninstallData = UninstallData.getInstance();
        for (int i = 0; i < this.files.size(); ++i) {
            uninstallData.addFile(this.files.elementAt(i), true);
        }
    }

    public static ShortcutPanel getInstance() {
        return self;
    }

    @Override
    public void makeXMLData(XMLElement xMLElement) {
        Debug.log("entering makeXMLData");
        if (!this.shortcutsToCreate || !this.shortcut.supported() || this.groupName == null || this.simulteNotSupported || !create) {
            Debug.log("abort makeXMLData!");
            return;
        }
        XMLElement xMLElement2 = new XMLElement("programGroup");
        xMLElement2.setAttribute("name", this.groupName);
        xMLElement.addChild(xMLElement2);
        for (int i = 0; i < this.shortcuts.size(); ++i) {
            Debug.log("entering makeXMLData");
            ShortcutData shortcutData = (ShortcutData)this.shortcuts.elementAt(i);
            xMLElement2 = new XMLElement("shortcut");
            xMLElement2.setAttribute("name", shortcutData.name);
            xMLElement2.setAttribute(AUTO_ATTRIBUTE_GROUP, (shortcutData.addToGroup ? Boolean.TRUE : Boolean.FALSE).toString());
            if (OsVersion.IS_WINDOWS) {
                xMLElement2.setAttribute("type", Integer.toString(shortcutData.type));
            }
            xMLElement2.setAttribute("commandLine", shortcutData.commandLine);
            xMLElement2.setAttribute("description", shortcutData.description);
            xMLElement2.setAttribute(AUTO_ATTRIBUTE_ICON, shortcutData.iconFile);
            xMLElement2.setAttribute("iconIndex", Integer.toString(shortcutData.iconIndex));
            xMLElement2.setAttribute("initialState", Integer.toString(shortcutData.initialState));
            xMLElement2.setAttribute("target", shortcutData.target);
            xMLElement2.setAttribute("workingDirectory", shortcutData.workingDirectory);
            xMLElement2.setAttribute(SPEC_ATTRIBUTE_ENCODING, shortcutData.deskTopEntryLinux_Encoding);
            xMLElement2.setAttribute(SPEC_ATTRIBUTE_MIMETYPE, shortcutData.deskTopEntryLinux_MimeType);
            xMLElement2.setAttribute(SPEC_ATTRIBUTE_TERMINAL, shortcutData.deskTopEntryLinux_Terminal);
            xMLElement2.setAttribute(SPEC_ATTRIBUTE_TERMINAL_OPTIONS, shortcutData.deskTopEntryLinux_TerminalOptions);
            if (!OsVersion.IS_WINDOWS) {
                xMLElement2.setAttribute("type", shortcutData.deskTopEntryLinux_Type);
            }
            xMLElement2.setAttribute(SPEC_ATTRIBUTE_URL, shortcutData.deskTopEntryLinux_URL);
            xMLElement2.setAttribute(SPEC_ATTRIBUTE_KDE_SUBST_UID, shortcutData.deskTopEntryLinux_X_KDE_SubstituteUID);
            xMLElement2.setAttribute(SPEC_CATEGORIES, shortcutData.Categories);
            xMLElement2.setAttribute(SPEC_TRYEXEC, shortcutData.TryExec);
            xMLElement2.setAttribute(CREATE_FOR_ALL, shortcutData.createForAll.toString());
            xMLElement2.setAttribute(USER_TYPE, Integer.toString(shortcutData.userType));
            if (shortcutData.type == 3 && (shortcutData.type != 3 || !this.allowDesktopShortcut.isSelected())) continue;
            xMLElement.addChild(xMLElement2);
        }
    }

    static {
        createImmediately = true;
    }
}

