/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.Pack;
import com.izforge.izpack.ParsableFile;
import com.izforge.izpack.UpdateCheck;
import com.izforge.izpack.XPackFile;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.MultiVolumeInstaller;
import com.izforge.izpack.installer.ScriptParser;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.installer.UnpackerBase;
import com.izforge.izpack.io.CorruptVolumeException;
import com.izforge.izpack.io.FileSpanningInputStream;
import com.izforge.izpack.io.VolumeNotFoundException;
import com.izforge.izpack.panels.NextMediaDialog;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsConstraint;
import java.awt.Component;
import java.awt.Frame;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.swing.JOptionPane;

public class MultiVolumeUnpacker
extends UnpackerBase {
    public MultiVolumeUnpacker(AutomatedInstallData automatedInstallData, AbstractUIProgressHandler abstractUIProgressHandler) {
        super(automatedInstallData, abstractUIProgressHandler);
    }

    protected File enterNextMediaMessage(String string, boolean bl) {
        Serializable serializable;
        if (bl) {
            serializable = null;
            if (this.handler != null && this.handler instanceof IzPanel) {
                serializable = ((IzPanel)((Object)this.handler)).getInstallerFrame();
            }
            JOptionPane.showMessageDialog((Component)serializable, this.idata.langpack.getString("nextmedia.corruptmedia"), this.idata.langpack.getString("nextmedia.corruptmedia.title"), 0);
        }
        Debug.trace("Enter next media: " + string);
        serializable = new File(string);
        NextMediaDialog nextMediaDialog = null;
        while (!((File)serializable).exists() || bl) {
            Object object;
            if (this.handler != null && this.handler instanceof IzPanel) {
                object = ((IzPanel)((Object)this.handler)).getInstallerFrame();
                nextMediaDialog = new NextMediaDialog((Frame)object, this.idata, string);
            } else {
                nextMediaDialog = new NextMediaDialog(null, this.idata, string);
            }
            nextMediaDialog.setVisible(true);
            object = nextMediaDialog.getNextMedia();
            if (object != null) {
                serializable = new File((String)object);
            } else {
                Debug.trace("Input from NextMediaDialog was null");
                serializable = new File(string);
            }
            if (string.equals(((File)serializable).getAbsolutePath()) && bl) continue;
            bl = false;
        }
        return serializable;
    }

    protected File enterNextMediaMessage(String string) {
        return this.enterNextMediaMessage(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.addToInstances();
        try {
            FileOutputStream fileOutputStream = null;
            ArrayList<ParsableFile> arrayList = new ArrayList<ParsableFile>();
            ArrayList<ExecutableFile> arrayList2 = new ArrayList<ExecutableFile>();
            ArrayList<UpdateCheck> arrayList3 = new ArrayList<UpdateCheck>();
            List list = this.idata.selectedPacks;
            int n = list.size();
            Debug.trace("Unpacker starting");
            this.handler.startAction("Unpacking", n);
            this.udata = UninstallData.getInstance();
            List[] listArray = this.getCustomActions();
            this.informListeners(listArray, 7, this.idata, n, this.handler);
            list = this.idata.selectedPacks;
            n = list.size();
            if (n == 0) {
                if (this.performInterrupted()) {
                    return;
                }
                this.informListeners(listArray, 8, this.idata, this.handler, null);
                if (this.performInterrupted()) {
                    return;
                }
                this.handler.stopAction();
                return;
            }
            InputStream inputStream = MultiVolumeUnpacker.class.getResourceAsStream("/volumes.info");
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            int n2 = objectInputStream.readInt();
            String string = objectInputStream.readUTF();
            Debug.trace("Reading from " + n2 + " volumes with basename " + string + " ");
            objectInputStream.close();
            String string2 = MultiVolumeInstaller.getMediadirectory();
            if (string2 == null || string2.length() <= 0) {
                Debug.trace("Mediadirectory wasn't set.");
                string2 = System.getProperty("java.io.tmpdir");
            }
            Debug.trace("Using mediadirectory = " + string2);
            File file = new File(string2 + File.separator + string);
            if (!file.exists()) {
                file = this.enterNextMediaMessage(file.getAbsolutePath());
            }
            FileSpanningInputStream fileSpanningInputStream = new FileSpanningInputStream(file, n2);
            for (int i = 0; i < n; ++i) {
                int n3;
                int n4;
                Object object;
                Serializable serializable;
                Object object2;
                int n5;
                String string3;
                int n6 = this.idata.allPacks.indexOf(list.get(i));
                inputStream = MultiVolumeUnpacker.class.getResourceAsStream("/packs/pack" + n6);
                this.informListeners(listArray, 5, list.get(i), n, this.handler);
                ObjectInputStream objectInputStream2 = new ObjectInputStream(inputStream);
                int n7 = objectInputStream2.readInt();
                Pack pack = (Pack)list.get(i);
                if (pack.hasCondition() && this.rules != null && !this.rules.isConditionTrue(pack.getCondition())) continue;
                String string4 = pack.name;
                if (this.langpack != null && pack.id != null && !"".equals(pack.id) && (string3 = this.langpack.getString(pack.id)) != null && !"".equals(string3)) {
                    string4 = string3;
                }
                this.handler.nextStep(string4, i + 1, n7);
                for (n5 = 0; n5 < n7; ++n5) {
                    XPackFile xPackFile = (XPackFile)objectInputStream2.readObject();
                    if (xPackFile.hasCondition() && this.rules != null && !this.rules.isConditionTrue(xPackFile.getCondition())) continue;
                    if (OsConstraint.oneMatchesCurrentSystem(xPackFile.osConstraints())) {
                        object2 = IoHelper.translatePath(xPackFile.getTargetPath(), this.vs);
                        serializable = new File((String)object2);
                        object = serializable;
                        if (!xPackFile.isDirectory()) {
                            object = ((File)serializable).getParentFile();
                        }
                        if (!((File)object).exists()) {
                            List list2 = listArray[listArray.length - 1];
                            if (list2 != null && list2.size() > 0) {
                                this.mkDirsWithEnhancement((File)object, xPackFile, listArray);
                            } else if (!((File)object).mkdirs()) {
                                this.handler.emitError("Error creating directories", "Could not create directory\n" + ((File)object).getPath());
                                this.handler.stopAction();
                                this.result = false;
                                return;
                            }
                        }
                        if (xPackFile.isDirectory()) continue;
                        this.informListeners(listArray, 1, serializable, xPackFile, null);
                        this.udata.addFile((String)object2, pack.uninstall);
                        this.handler.progress(n5, (String)object2);
                        if (((File)serializable).exists() && xPackFile.override() != 1) {
                            boolean bl = false;
                            if (xPackFile.override() != 0) {
                                if (xPackFile.override() == 1) {
                                    bl = true;
                                } else if (xPackFile.override() == 4) {
                                    bl = ((File)serializable).lastModified() < xPackFile.lastModified();
                                } else {
                                    int n8;
                                    int n9 = -1;
                                    if (xPackFile.override() == 2) {
                                        n9 = 49;
                                    }
                                    if (xPackFile.override() == 3) {
                                        n9 = 47;
                                    }
                                    boolean bl2 = bl = (n8 = this.handler.askQuestion(this.idata.langpack.getString("InstallPanel.overwrite.title") + " - " + ((File)serializable).getName(), this.idata.langpack.getString("InstallPanel.overwrite.question") + ((File)serializable).getAbsolutePath(), 37, n9)) == 47;
                                }
                            }
                            if (!bl) {
                                if (xPackFile.isBackReference() || ((Pack)list.get((int)i)).loose) continue;
                                continue;
                            }
                        }
                        fileOutputStream = new FileOutputStream((File)serializable);
                        byte[] byArray = new byte[5120];
                        long l = 0L;
                        InputStream inputStream2 = fileSpanningInputStream;
                        if (((Pack)list.get((int)i)).loose) {
                            inputStream2 = new FileInputStream(xPackFile.sourcePath);
                        }
                        long l2 = xPackFile.getArchivefileposition();
                        while (fileSpanningInputStream.getFilepointer() < l2) {
                            File file2;
                            Debug.trace("Skipping bytes to get to file " + ((File)serializable).getName() + " (" + fileSpanningInputStream.getFilepointer() + "<" + l2 + ") target is: " + (l2 - fileSpanningInputStream.getFilepointer()));
                            try {
                                fileSpanningInputStream.skip(l2 - fileSpanningInputStream.getFilepointer());
                                break;
                            }
                            catch (VolumeNotFoundException volumeNotFoundException) {
                                file2 = this.enterNextMediaMessage(volumeNotFoundException.getVolumename());
                                fileSpanningInputStream.setVolumename(file2.getAbsolutePath());
                            }
                            catch (CorruptVolumeException corruptVolumeException) {
                                Debug.trace("corrupt media found. magic number is not correct");
                                file2 = this.enterNextMediaMessage(corruptVolumeException.getVolumename(), true);
                                fileSpanningInputStream.setVolumename(file2.getAbsolutePath());
                            }
                        }
                        if (fileSpanningInputStream.getFilepointer() > l2) {
                            Debug.trace("Error, can't access file in pack.");
                        }
                        while (l < xPackFile.length()) {
                            block68: {
                                if (!this.performInterrupted()) break block68;
                                fileOutputStream.close();
                                if (inputStream2 != objectInputStream2) {
                                    inputStream2.close();
                                }
                                return;
                            }
                            try {
                                int n10 = (int)Math.min(xPackFile.length() - l, (long)byArray.length);
                                int n11 = inputStream2.read(byArray, 0, n10);
                                if (n11 == -1) {
                                    Debug.trace("Unexpected end of stream (installer corrupted?)");
                                    throw new IOException("Unexpected end of stream (installer corrupted?)");
                                }
                                fileOutputStream.write(byArray, 0, n11);
                                l += (long)n11;
                            }
                            catch (VolumeNotFoundException volumeNotFoundException) {
                                File file3 = this.enterNextMediaMessage(volumeNotFoundException.getVolumename());
                                fileSpanningInputStream.setVolumename(file3.getAbsolutePath());
                            }
                            catch (CorruptVolumeException corruptVolumeException) {
                                Debug.trace("corrupt media found. magic number is not correct");
                                File file4 = this.enterNextMediaMessage(corruptVolumeException.getVolumename(), true);
                                fileSpanningInputStream.setVolumename(file4.getAbsolutePath());
                            }
                        }
                        fileOutputStream.close();
                        if (xPackFile.lastModified() >= 0L) {
                            ((File)serializable).setLastModified(xPackFile.lastModified());
                        }
                        this.informListeners(listArray, 2, serializable, xPackFile, null);
                        continue;
                    }
                    if (xPackFile.isBackReference()) continue;
                }
                n5 = objectInputStream2.readInt();
                Debug.trace("Looking for parsables");
                for (n4 = 0; n4 < n5; ++n4) {
                    object2 = null;
                    while (true) {
                        try {
                            object2 = (ParsableFile)objectInputStream2.readObject();
                        }
                        catch (VolumeNotFoundException volumeNotFoundException) {
                            object = this.enterNextMediaMessage(volumeNotFoundException.getVolumename());
                            fileSpanningInputStream.setVolumename(((File)object).getAbsolutePath());
                            continue;
                        }
                        catch (CorruptVolumeException corruptVolumeException) {
                            Debug.trace("corrupt media found. magic number is not correct");
                            object = this.enterNextMediaMessage(corruptVolumeException.getVolumename(), true);
                            fileSpanningInputStream.setVolumename(((File)object).getAbsolutePath());
                            continue;
                        }
                        catch (EOFException eOFException) {
                            object = this.enterNextMediaMessage("");
                            fileSpanningInputStream.setVolumename(((File)object).getAbsolutePath());
                            continue;
                        }
                        break;
                    }
                    if (((ParsableFile)object2).hasCondition() && this.rules != null && !this.rules.isConditionTrue(((ParsableFile)object2).getCondition())) continue;
                    ((ParsableFile)object2).path = IoHelper.translatePath(((ParsableFile)object2).path, this.vs);
                    Debug.trace("Found parsable: " + ((ParsableFile)object2).path);
                    arrayList.add((ParsableFile)object2);
                }
                n4 = objectInputStream2.readInt();
                Debug.trace("Looking for executables...");
                for (n3 = 0; n3 < n4; ++n3) {
                    serializable = (ExecutableFile)objectInputStream2.readObject();
                    if (((ExecutableFile)serializable).hasCondition() && this.rules != null && !this.rules.isConditionTrue(((ExecutableFile)serializable).getCondition())) continue;
                    ((ExecutableFile)serializable).path = IoHelper.translatePath(((ExecutableFile)serializable).path, this.vs);
                    if (null != ((ExecutableFile)serializable).argList && !((ExecutableFile)serializable).argList.isEmpty()) {
                        object = null;
                        for (int j = 0; j < ((ExecutableFile)serializable).argList.size(); ++j) {
                            object = ((ExecutableFile)serializable).argList.get(j);
                            object = IoHelper.translatePath((String)object, this.vs);
                            ((ExecutableFile)serializable).argList.set(j, (String)object);
                        }
                    }
                    Debug.trace("Found executable: " + ((ExecutableFile)serializable).path);
                    arrayList2.add((ExecutableFile)serializable);
                    if (((ExecutableFile)serializable).executionStage != 2) continue;
                    this.udata.addExecutable((ExecutableFile)serializable);
                }
                this.handleAdditionalUninstallData(this.udata, listArray);
                n3 = objectInputStream2.readInt();
                Debug.trace("Looking for updatechecks");
                for (int j = 0; j < n3; ++j) {
                    object = (UpdateCheck)objectInputStream2.readObject();
                    Debug.trace("found updatecheck");
                    arrayList3.add((UpdateCheck)object);
                }
                if (this.performInterrupted()) {
                    return;
                }
                this.informListeners(listArray, 6, list.get(i), i, this.handler);
            }
            Debug.trace("Trying to parse files");
            ScriptParser scriptParser = new ScriptParser(arrayList, this.vs);
            scriptParser.parseFiles();
            Debug.trace("parsed files");
            if (this.performInterrupted()) {
                return;
            }
            Debug.trace("Trying to execute files");
            FileExecutor fileExecutor = new FileExecutor(arrayList2);
            if (fileExecutor.executeFiles(0, this.handler) != 0) {
                this.handler.emitError("File execution failed", "The installation was not completed");
                this.result = false;
                Debug.trace("File execution failed");
            }
            if (this.performInterrupted()) {
                return;
            }
            Debug.trace("Create uninstaller");
            this.putUninstaller();
            Debug.trace("Uninstaller created");
            Debug.trace("Perform updateChecks");
            this.performUpdateChecks(arrayList3);
            Debug.trace("updatechecks performed.");
            if (this.performInterrupted()) {
                return;
            }
            this.informListeners(listArray, 8, this.idata, this.handler, null);
            if (this.performInterrupted()) {
                return;
            }
            this.writeInstallationInformation();
            this.writeConfigInformation();
            this.handler.stopAction();
            Debug.trace("Installation complete");
        }
        catch (Exception exception) {
            this.handler.stopAction();
            this.handler.emitError("An error occured", exception.toString());
            exception.printStackTrace();
            Debug.trace("Error while installing: " + exception.toString());
            this.result = false;
        }
        finally {
            this.removeFromInstances();
        }
    }

    protected void writeConfigInformation() {
        Properties properties = this.idata.getVariables();
        Enumeration<Object> enumeration = properties.keys();
        try {
            String string = this.idata.getVariable("INSTALL_PATH");
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(string + File.separator + "installer.properties"));
            printWriter.println("# Installer properties, written by MultiVolumeUnpacker.");
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (string2.startsWith("SYSTEM_") || string2.startsWith("password_")) continue;
                printWriter.println(string2 + "=" + properties.getProperty(string2));
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            Debug.trace("Error while writing config information in MultiVolumeUnpacker: " + exception.getMessage());
        }
    }
}

