/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.CustomData;
import com.izforge.izpack.Info;
import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallerException;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

public class InstallerBase {
    protected static final String LANG_FILE_NAME = "CustomLangpack.xml";

    public void loadInstallData(AutomatedInstallData automatedInstallData) throws Exception {
        Object object5;
        Object object2;
        String string;
        String string2;
        Object object3;
        Object object4;
        ObjectInputStream objectInputStream;
        Properties properties = null;
        InputStream inputStream = InstallerBase.class.getResourceAsStream("/vars");
        if (null != inputStream) {
            objectInputStream = new ObjectInputStream(inputStream);
            properties = (Properties)objectInputStream.readObject();
            objectInputStream.close();
        }
        inputStream = InstallerBase.class.getResourceAsStream("/info");
        objectInputStream = new ObjectInputStream(inputStream);
        Info info = (Info)objectInputStream.readObject();
        objectInputStream.close();
        automatedInstallData.setVariable("APP_NAME", info.getAppName());
        if (info.getAppURL() != null) {
            automatedInstallData.setVariable("APP_URL", info.getAppURL());
        }
        automatedInstallData.setVariable("APP_VER", info.getAppVersion());
        if (info.getUninstallerCondition() != null) {
            automatedInstallData.setVariable("UNINSTALLER_CONDITION", info.getUninstallerCondition());
        }
        inputStream = InstallerBase.class.getResourceAsStream("/panelsOrder");
        objectInputStream = new ObjectInputStream(inputStream);
        List list = (List)objectInputStream.readObject();
        objectInputStream.close();
        inputStream = InstallerBase.class.getResourceAsStream("/packs.info");
        objectInputStream = new ObjectInputStream(inputStream);
        int n = objectInputStream.readInt();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Pack> arrayList2 = new ArrayList<Pack>();
        for (int i = 0; i < n; ++i) {
            object4 = (Pack)objectInputStream.readObject();
            arrayList2.add((Pack)object4);
            if (!OsConstraint.oneMatchesCurrentSystem(((Pack)object4).osConstraints)) continue;
            arrayList.add(object4);
        }
        objectInputStream.close();
        object4 = OsVersion.IS_WINDOWS ? this.buildWindowsDefaultPath() : (OsVersion.IS_OSX ? "/Applications" : (new File("/usr/local/").canWrite() ? "/usr/local" : System.getProperty("user.home")));
        try {
            object3 = InetAddress.getLocalHost();
            string2 = ((InetAddress)object3).getHostAddress();
            string = ((InetAddress)object3).getHostName();
        }
        catch (Exception exception) {
            string = "";
            string2 = "";
        }
        automatedInstallData.setVariable("APPLICATIONS_DEFAULT_ROOT", (String)object4);
        object4 = (String)object4 + File.separator;
        automatedInstallData.setVariable("JAVA_HOME", System.getProperty("java.home"));
        automatedInstallData.setVariable("CLASS_PATH", System.getProperty("java.class.path"));
        automatedInstallData.setVariable("USER_HOME", System.getProperty("user.home"));
        automatedInstallData.setVariable("USER_NAME", System.getProperty("user.name"));
        automatedInstallData.setVariable("IP_ADDRESS", string2);
        automatedInstallData.setVariable("HOST_NAME", string);
        automatedInstallData.setVariable("FILE_SEPARATOR", File.separator);
        object3 = System.getProperties().keys();
        while (object3.hasMoreElements()) {
            object2 = (String)object3.nextElement();
            object5 = System.getProperty((String)object2);
            if (object5 == null) continue;
            object2 = ((String)object2).replace('.', '_');
            automatedInstallData.setVariable("SYSTEM_" + object2, (String)object5);
        }
        if (null != properties) {
            object2 = properties.keys();
            while (object2.hasMoreElements()) {
                object5 = (String)object2.nextElement();
                String string3 = properties.getProperty((String)object5);
                automatedInstallData.setVariable((String)object5, string3);
            }
        }
        automatedInstallData.info = info;
        automatedInstallData.panelsOrder = list;
        automatedInstallData.availablePacks = arrayList;
        automatedInstallData.allPacks = arrayList2;
        for (Object object5 : arrayList) {
            if (!((Pack)object5).preselected) continue;
            automatedInstallData.selectedPacks.add(object5);
        }
        String string4 = (String)object4 + info.getAppName();
        if (info.getInstallationSubPath() != null) {
            string4 = IoHelper.translatePath((String)object4 + info.getInstallationSubPath(), new VariableSubstitutor(automatedInstallData.getVariables()));
        }
        automatedInstallData.setInstallPath(string4);
        this.loadCustomData(automatedInstallData);
    }

    protected void addCustomLangpack(AutomatedInstallData automatedInstallData) {
        try {
            automatedInstallData.langpack.add(ResourceManager.getInstance().getInputStream(LANG_FILE_NAME));
        }
        catch (Throwable throwable) {
            Debug.trace("No custom langpack available.");
            return;
        }
        Debug.trace("Custom langpack for " + automatedInstallData.localeISO3 + " available.");
    }

    private String buildWindowsDefaultPath() {
        try {
            String string = IoHelper.getenv("ProgramFiles");
            if (string != null && string.length() > 0) {
                return string;
            }
            return this.buildWindowsDefaultPathFromProps();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.buildWindowsDefaultPathFromProps();
        }
    }

    private String buildWindowsDefaultPathFromProps() {
        StringBuffer stringBuffer = new StringBuffer("");
        try {
            Properties properties = new Properties();
            properties.load(InstallerBase.class.getResourceAsStream("/com/izforge/izpack/installer/win32-defaultpaths.properties"));
            String string = System.getProperty("user.home");
            if (string.length() > 3) {
                string = string.substring(0, 3);
            }
            stringBuffer.append(string);
            if (string.length() == 2) {
                stringBuffer.append("\\");
            }
            String string2 = Locale.getDefault().getLanguage();
            String string3 = Locale.getDefault().getCountry();
            String string4 = string2 + "_" + string3;
            if (null != properties.getProperty(string4)) {
                stringBuffer.append(properties.getProperty(string4));
            } else if (null != properties.getProperty(string2)) {
                stringBuffer.append(properties.getProperty(string2));
            } else {
                stringBuffer.append(properties.getProperty(Locale.ENGLISH.getLanguage()));
            }
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer("C:\\Program Files");
        }
        return stringBuffer.toString();
    }

    private void loadCustomData(AutomatedInstallData automatedInstallData) throws Exception {
        int n;
        String[] stringArray = AutomatedInstallData.CUSTOM_ACTION_TYPES;
        List[] listArray = new List[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            listArray[n] = new ArrayList();
        }
        InputStream inputStream = InstallerBase.class.getResourceAsStream("/customData");
        if (inputStream != null) {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            Iterator iterator = ((List)object).iterator();
            while (iterator != null && iterator.hasNext()) {
                CustomData customData = (CustomData)iterator.next();
                if (customData.osConstraints != null && !OsConstraint.oneMatchesCurrentSystem(customData.osConstraints)) continue;
                switch (customData.type) {
                    case 0: {
                        Class<?> clazz = Class.forName(customData.listenerName);
                        if (clazz == null) {
                            throw new InstallerException("Custom action " + customData.listenerName + " not bound!");
                        }
                        listArray[customData.type].add(clazz.newInstance());
                        break;
                    }
                    case 1: 
                    case 3: {
                        listArray[customData.type].add(customData);
                        break;
                    }
                    case 2: {
                        listArray[customData.type].add(customData.contents);
                    }
                }
            }
            for (n = 0; n < stringArray.length; ++n) {
                automatedInstallData.customData.put(stringArray[n], listArray[n]);
            }
        }
    }
}

