/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.os.unix;

import com.izforge.izpack.util.StringTool;
import com.izforge.izpack.util.os.unix.UnixHelper;
import com.izforge.izpack.util.os.unix.UnixUser;
import java.io.File;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnixUsers
extends ArrayList {
    private static final long serialVersionUID = -4804842346742194981L;

    public UnixUsers() {
        this.fromUsersArrayList(UnixUsers.getEtcPasswdUsersAsArrayList());
        this.fromUsersArrayList(UnixUsers.getYpPasswdUsersAsArrayList());
    }

    public ArrayList<UnixUser> getUsersWithValidShells() {
        ArrayList<UnixUser> arrayList = new ArrayList<UnixUser>();
        for (int i = 0; i < this.size(); ++i) {
            UnixUser unixUser = (UnixUser)this.get(i);
            if (unixUser.getShell() == null || !unixUser.getShell().trim().endsWith("sh")) continue;
            arrayList.add(unixUser);
        }
        return arrayList;
    }

    public ArrayList<UnixUser> getUsersWithValidShellsAndExistingHomes() {
        ArrayList<UnixUser> arrayList = new ArrayList<UnixUser>();
        ArrayList<UnixUser> arrayList2 = this.getUsersWithValidShells();
        for (int i = 0; i < arrayList2.size(); ++i) {
            UnixUser unixUser = arrayList2.get(i);
            if (unixUser.getHome() == null || !new File(unixUser.getHome().trim()).exists()) continue;
            arrayList.add(unixUser);
        }
        return arrayList;
    }

    public ArrayList _getUsersWithValidShellsExistingHomesAndDesktops() {
        ArrayList<UnixUser> arrayList = new ArrayList<UnixUser>();
        ArrayList<UnixUser> arrayList2 = this.getUsersWithValidShellsAndExistingHomes();
        for (int i = 0; i < arrayList2.size(); ++i) {
            UnixUser unixUser = arrayList2.get(i);
            if (unixUser.getHome() == null || !new File(unixUser.getHome().trim() + File.separator + "Desktop").exists()) continue;
            arrayList.add(unixUser);
        }
        return arrayList;
    }

    public ArrayList<String> getValidUsersDesktopFolders() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = UnixUsers.getUsersWithValidShellsExistingHomesAndDesktops();
        for (int i = 0; i < arrayList2.size(); ++i) {
            File file;
            UnixUser unixUser = (UnixUser)arrayList2.get(i);
            new File(unixUser.getHome().trim() + File.separator + "Desktop");
            if (unixUser.getHome() == null || !(file = new File(unixUser.getHome().trim() + File.separator + "Desktop")).exists() || !file.isDirectory()) continue;
            arrayList.add(file.toString());
        }
        return arrayList;
    }

    public static ArrayList getUsersWithValidShellsExistingHomesAndDesktops() {
        UnixUsers unixUsers = new UnixUsers();
        return unixUsers._getUsersWithValidShellsExistingHomesAndDesktops();
    }

    private void fromUsersArrayList(ArrayList<String> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            this.add(new UnixUser().fromEtcPasswdLine(arrayList.get(i)));
        }
    }

    public static ArrayList<String> getEtcPasswdUsersAsArrayList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = UnixHelper.getEtcPasswdArray();
        for (int i = 0; i < arrayList2.size(); ++i) {
            String string = arrayList2.get(i);
            arrayList.add(string);
        }
        return arrayList;
    }

    public static ArrayList<String> getYpPasswdUsersAsArrayList() {
        return UnixHelper.getYpPasswdArray();
    }

    public static String getUsersColonString() {
        ArrayList<String> arrayList = UnixUsers.getEtcPasswdUsersAsArrayList();
        String string = "";
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = arrayList.get(i);
            string = string + string2.substring(0, string2.indexOf(":")) + ":";
        }
        if (string.endsWith(":")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static void main(String[] stringArray) {
        System.out.println("UnixUsers:");
        UnixUsers unixUsers = new UnixUsers();
        for (int i = 0; i < unixUsers.size(); ++i) {
            System.out.println(((UnixUser)unixUsers.get(i)).getName());
        }
        System.out.println(StringTool.stringArrayListToString(UnixUsers.getUsersWithValidShellsExistingHomesAndDesktops()));
    }
}

