/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.os;

import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.StringTool;
import com.izforge.izpack.util.os.Shortcut;
import com.izforge.izpack.util.os.Unix_ShortcutConstants;
import com.izforge.izpack.util.os.unix.ShellScript;
import com.izforge.izpack.util.os.unix.UnixHelper;
import com.izforge.izpack.util.os.unix.UnixUser;
import com.izforge.izpack.util.os.unix.UnixUsers;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Unix_Shortcut
extends Shortcut
implements Unix_ShortcutConstants {
    private static String version = "$Id: Unix_Shortcut.java 2163 2008-05-18 13:48:36Z jponge $";
    private static String rev = "$Revision: 2163 $";
    private static String DESKTOP_EXT = ".desktop";
    private static String template = "";
    private static final String N = "\n";
    private static final String H = "#";
    private static final String S = " ";
    private static final String C = "# ";
    private static final String QM = "\"";
    private int ShortcutType;
    private static ShellScript rootScript = null;
    private static ShellScript uninstallScript = null;
    private static ArrayList users = UnixUsers.getUsersWithValidShellsExistingHomesAndDesktops();
    private String createdDirectory;
    private int itsUserType;
    private String itsGroupName;
    private String itsName;
    private String itsFileName;
    private String itsApplnkFolder = "applnk";
    private Properties props;
    private Boolean forAll = Boolean.FALSE;
    public StringBuffer hlp = new StringBuffer();
    private String writtenFileName;

    public Unix_Shortcut() {
        String string = System.getProperty("user.language", "en");
        this.hlp.append("[Desktop Entry]\n");
        this.hlp.append("Categories=$Categories\n");
        this.hlp.append("Comment=$Comment\n");
        this.hlp.append("Comment[").append(string).append("]=$Comment\n");
        this.hlp.append("Encoding=$Encoding\n");
        this.hlp.append("Exec=$E_QUOT$Exec$E_QUOT $Arguments\n");
        this.hlp.append("GenericName=$GenericName\n");
        this.hlp.append("GenericName[").append(string).append("]=$GenericName\n");
        this.hlp.append("Icon=$Icon\n");
        this.hlp.append("MimeType=$MimeType\n");
        this.hlp.append("Name=$Name\n");
        this.hlp.append("Name[").append(string).append("]=$Name\n");
        this.hlp.append("Path=$P_QUOT$Path$P_QUOT\n");
        this.hlp.append("ServiceTypes=$ServiceTypes\n");
        this.hlp.append("SwallowExec=$SwallowExec\n");
        this.hlp.append("SwallowTitle=$SwallowTitle\n");
        this.hlp.append("Terminal=$Terminal\n");
        this.hlp.append("TerminalOptions=$Options_For_Terminal\n");
        this.hlp.append("Type=$Type\n");
        this.hlp.append("URL=$URL\n");
        this.hlp.append("X-KDE-SubstituteUID=$X_KDE_SubstituteUID\n");
        this.hlp.append("X-KDE-Username=$X_KDE_Username\n");
        this.hlp.append(N);
        this.hlp.append("# created by ").append(this.getClass().getName()).append(S).append(rev).append(N);
        this.hlp.append(C).append(version);
        template = this.hlp.toString();
        this.props = new Properties();
        this.initProps();
        if (rootScript == null) {
            rootScript = new ShellScript();
        }
        if (uninstallScript == null) {
            uninstallScript = new ShellScript();
        }
    }

    private void initProps() {
        String[] stringArray;
        for (String string : stringArray = new String[]{"$Comment", "$$LANG_Comment", "$Encoding", "$Exec", "$Arguments", "$GenericName", "$$LANG_GenericName", "$MimeType", "$Name", "$$LANG_Name", "$Path", "$ServiceTypes", "$SwallowExec", "$SwallowTitle", "$Terminal", "$Options_For_Terminal", "$Type", "$X_KDE_SubstituteUID", "$X_KDE_Username", "$Icon", "$URL", "$E_QUOT", "$P_QUOT", "$Categories", "$TryExec"}) {
            this.props.put(string, "");
        }
    }

    @Override
    public void initialize(int n, String string) throws Exception {
        this.itsName = string;
        this.props.put("$Name", string);
    }

    @Override
    public boolean supported() {
        return true;
    }

    @Override
    public String getDirectoryCreated() {
        return this.createdDirectory;
    }

    @Override
    public String getFileName() {
        return this.itsFileName;
    }

    @Override
    public Vector<String> getProgramGroups(int n) {
        Vector<String> vector = new Vector<String>();
        File file = this.getKdeShareApplnkFolder(n);
        try {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                if (!file2.isDirectory()) continue;
                vector.add(file2.getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vector;
    }

    @Override
    public String getProgramsFolder(int n) {
        String string = "";
        string = this.getKdeShareApplnkFolder(n).toString();
        return string;
    }

    private File getKdeShareApplnkFolder(int n) {
        if (n == 2) {
            return new File(File.separator + "usr" + File.separator + "share" + File.separator + "applications");
        }
        return new File(System.getProperty("user.home") + File.separator + ".local" + File.separator + "share" + File.separator + "applications");
    }

    private String getKdeApplinkFolderName() {
        String string = "applnk";
        if (OsVersion.IS_REDHAT_LINUX) {
            string = "applnk-redhat";
        }
        if (OsVersion.IS_MANDRAKE_LINUX) {
            string = "applnk-mdk";
        }
        return string;
    }

    private File getKdeBase(int n) {
        File file = null;
        if (n == 2) {
            FileExecutor fileExecutor = new FileExecutor();
            String[] stringArray = new String[2];
            int n2 = fileExecutor.executeCommand(new String[]{"/usr/bin/env", "kde-config", "--prefix"}, stringArray);
            file = new File(stringArray[0].trim());
        } else {
            file = new File(System.getProperty("user.home") + File.separator + ".kde");
        }
        return file;
    }

    @Override
    public boolean multipleUsers() {
        return true;
    }

    @Override
    public void save() throws Exception {
        String string = File.separator;
        String string2 = UnixHelper.getCustomCommand("chmod");
        String string3 = UnixHelper.getCustomCommand("chown");
        String string4 = UnixHelper.getRmCommand();
        String string5 = UnixHelper.getCpCommand();
        String string6 = UnixHelper.getSuCommand();
        String string7 = System.getProperty("user.home");
        Object var8_8 = null;
        String string8 = this.replace();
        boolean bl = this.getUserType() == 2;
        boolean bl2 = this.getCreateForAll();
        if ("".equals(this.itsGroupName) && this.getLinkType() == 3) {
            this.itsFileName = var8_8;
            File file = this.writeSafeShortcut(string7 + string + "Desktop" + string, this.itsName, string8);
            this.uninstaller.addFile(file.toString(), true);
            if (bl && bl2) {
                File file2 = null;
                File file3 = File.createTempFile(this.getClass().getName(), Long.toString(System.currentTimeMillis()) + ".tmp");
                Unix_Shortcut.copyTo(file, file3);
                FileExecutor.getExecOutput(new String[]{string2, "uga+rwx", file3.toString()});
                for (Object e : users) {
                    UnixUser unixUser = (UnixUser)e;
                    if (unixUser.getHome().equals(string7)) {
                        Debug.log("need not to copy for itself: " + unixUser.getHome() + "==" + string7);
                        continue;
                    }
                    try {
                        file2 = new File(unixUser.getHome() + string + "Desktop" + string + file.getName());
                        rootScript.append(string6);
                        rootScript.append(S);
                        rootScript.append(unixUser.getName());
                        rootScript.append(S);
                        rootScript.append("-c");
                        rootScript.append(S);
                        rootScript.append('\"');
                        rootScript.append(string5);
                        rootScript.append(S);
                        rootScript.append(file3.toString());
                        rootScript.append(S);
                        rootScript.append(StringTool.replace(file2.toString(), S, "\\ "));
                        rootScript.appendln('\"');
                        rootScript.append('\n');
                        rootScript.append(string3);
                        rootScript.append(S);
                        rootScript.append(unixUser.getName());
                        rootScript.append(S);
                        rootScript.appendln(StringTool.replace(file2.toString(), S, "\\ "));
                        rootScript.append('\n');
                        rootScript.append('\n');
                        uninstallScript.append(string6);
                        uninstallScript.append(S);
                        uninstallScript.append(unixUser.getName());
                        uninstallScript.append(S);
                        uninstallScript.append("-c");
                        uninstallScript.append(S);
                        uninstallScript.append('\"');
                        uninstallScript.append(string4);
                        uninstallScript.append(S);
                        uninstallScript.append(StringTool.replace(file2.toString(), S, "\\ "));
                        uninstallScript.appendln('\"');
                        uninstallScript.appendln();
                    }
                    catch (Exception exception) {
                        System.out.println("Error while su Copy: " + exception.getLocalizedMessage() + "\n\n");
                        exception.printStackTrace();
                    }
                }
                rootScript.append(string4);
                rootScript.append(S);
                rootScript.appendln(file3.toString());
                rootScript.appendln();
            }
        } else if (bl && bl2) {
            File file = new File(this.getIconLocation());
            File file4 = new File("/usr/share/pixmaps/" + file.getName());
            try {
                Unix_Shortcut.copyTo(file, file4);
                this.uninstaller.addFile(file4.toString(), true);
            }
            catch (Exception exception) {
                Debug.log("Could Not Copy: " + file + " to " + file4 + "( " + exception.getMessage() + " )");
            }
            this.itsFileName = var8_8;
            File file5 = this.writeSafeShortcut("/usr/share/applications/", this.itsName, string8);
            this.setWrittenFileName(file5.getName());
            this.uninstaller.addFile(file5.toString(), true);
        } else {
            File file;
            String string9 = string7 + "/.local/share/applications/";
            String string10 = string7 + "/.local/share/pixmaps/";
            try {
                file = new File(string9);
                file.mkdirs();
                file = new File(string10);
                file.mkdirs();
            }
            catch (Exception exception) {
                Debug.log("Failed creating " + string9 + " or " + string10);
            }
            file = new File(this.getIconLocation());
            File file6 = new File(string10 + file.getName());
            try {
                Unix_Shortcut.copyTo(file, file6);
                this.uninstaller.addFile(file6.toString(), true);
            }
            catch (Exception exception) {
                Debug.log("Could Not Copy: " + file + " to " + file6 + "( " + exception.getMessage() + " )");
            }
            this.itsFileName = var8_8;
            File file7 = this.writeSafeShortcut(string9, this.itsName, string8);
            this.setWrittenFileName(file7.getName());
            this.uninstaller.addFile(file7.toString(), true);
        }
    }

    @Override
    public void execPostAction() {
        Debug.log("Call of Impl. execPostAction Method in " + this.getClass().getName());
        String string = this.getClass().getName() + Long.toString(System.currentTimeMillis());
        String string2 = null;
        try {
            string2 = File.createTempFile(string, ".sh").toString();
        }
        catch (IOException iOException) {
            string2 = System.getProperty("java.io.tmpdir", "/tmp") + "/" + string + ".sh";
            iOException.printStackTrace();
        }
        rootScript.write(string2);
        rootScript.exec();
        Debug.log(rootScript);
        Debug.log(uninstallScript);
        this.uninstaller.addRootUninstallScript(uninstallScript.getContentAsString());
    }

    public static void copyTo(File file, File file2) throws IOException {
        char[] cArray = new char[32768];
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
        int n = 0;
        long l = 0L;
        while ((n = bufferedReader.read(cArray, 0, cArray.length)) != -1) {
            bufferedWriter.write(cArray, 0, n);
            l += (long)n;
        }
        bufferedReader.close();
        bufferedWriter.close();
    }

    public String getWrittenFileName() {
        return this.writtenFileName;
    }

    protected void setWrittenFileName(String string) {
        this.writtenFileName = string;
    }

    private File writeSafeShortcut(String string, String string2, String string3) {
        File file;
        if (!string.endsWith("/") && !string.endsWith("\\")) {
            string = string + File.separatorChar;
        }
        while ((file = new File(string + string2 + "-" + System.currentTimeMillis() + DESKTOP_EXT)).exists()) {
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        try {
            fileWriter.write(string3);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return file;
    }

    private File writeShortCut(String string, String string2) {
        File file = new File(string.substring(0, string.lastIndexOf(File.separatorChar)));
        if (!file.exists()) {
            file.mkdirs();
            this.createdDirectory = file.toString();
        }
        File file2 = new File(string);
        File file3 = new File(file + File.separator + "." + file2.getName() + System.currentTimeMillis());
        if (file2.exists()) {
            try {
                Unix_Shortcut.copyTo(file2, file3);
                file2.delete();
            }
            catch (IOException iOException) {
                System.out.println("cannot create backup file " + file3 + " of " + file2);
            }
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file2);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        try {
            fileWriter.write(string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return file2;
    }

    @Override
    public void setArguments(String string) {
        this.props.put("$Arguments", string);
    }

    @Override
    public void setDescription(String string) {
        this.props.put("$Comment", string);
    }

    @Override
    public void setIconLocation(String string, int n) {
        this.props.put("$Icon", string);
    }

    @Override
    public void setLinkName(String string) {
        this.itsName = string;
        this.props.put("$Name", string);
    }

    @Override
    public void setLinkType(int n) throws IllegalArgumentException, UnsupportedEncodingException {
        this.ShortcutType = n;
    }

    @Override
    public void setProgramGroup(String string) {
        this.itsGroupName = string;
    }

    @Override
    public void setShowCommand(int n) {
    }

    @Override
    public void setTargetPath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() > 1) {
            this.props.put("$E_QUOT", QM);
        }
        this.props.put("$Exec", string);
    }

    @Override
    public void setUserType(int n) {
        this.itsUserType = n;
    }

    @Override
    public void setWorkingDirectory(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() > 1) {
            this.props.put("$P_QUOT", QM);
        }
        this.props.put("$Path", string);
    }

    public String toString() {
        return this.itsName + N + template;
    }

    public String replace() {
        String string = template;
        Enumeration<Object> enumeration = this.props.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            string = StringTool.replace(string, string2, this.props.getProperty(string2));
        }
        return string;
    }

    public static void main(String[] stringArray) {
        Unix_Shortcut unix_Shortcut = new Unix_Shortcut();
        try {
            unix_Shortcut.initialize(1, "Start Tomcat");
        }
        catch (Exception exception) {
            System.err.println("Could not init Unix_Shourtcut");
        }
        unix_Shortcut.replace();
        System.out.println(unix_Shortcut);
        File file = new File(System.getProperty("user.home") + File.separator + "Start Tomcat" + DESKTOP_EXT);
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            fileWriter.write(template);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void setEncoding(String string) {
        this.props.put("$Encoding", string);
    }

    @Override
    public void setKdeSubstUID(String string) {
        this.props.put("$X_KDE_SubstituteUID", string);
    }

    @Override
    public void setKdeUserName(String string) {
        this.props.put("$X_KDE_Username", string);
    }

    @Override
    public void setMimetype(String string) {
        this.props.put("$MimeType", string);
    }

    @Override
    public void setTerminal(String string) {
        this.props.put("$Terminal", string);
    }

    @Override
    public void setTerminalOptions(String string) {
        this.props.put("$Options_For_Terminal", string);
    }

    @Override
    public void setType(String string) {
        this.props.put("$Type", string);
    }

    @Override
    public void setURL(String string) {
        this.props.put("$URL", string);
    }

    @Override
    public int getUserType() {
        return this.itsUserType;
    }

    @Override
    public void setCategories(String string) {
        this.props.put("$Categories", string);
    }

    @Override
    public void setTryExec(String string) {
        this.props.put("$TryExec", string);
    }

    @Override
    public int getLinkType() {
        return this.ShortcutType;
    }
}

