/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.util.ConsoleTextArea;
import com.izforge.izpack.util.ConsoleWrite;
import java.io.OutputStream;
import javax.swing.SwingUtilities;

class ConsoleWriter
extends OutputStream {
    private ConsoleTextArea textArea;
    private StringBuffer buffer;

    public ConsoleWriter(ConsoleTextArea consoleTextArea) {
        this.textArea = consoleTextArea;
        this.buffer = new StringBuffer();
    }

    public synchronized void write(int n) {
        this.buffer.append((char)n);
        if (n == 10) {
            this.flushBuffer();
        }
    }

    public synchronized void write(char[] cArray, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            this.buffer.append(cArray[i]);
            if (cArray[i] != '\n') continue;
            this.flushBuffer();
        }
    }

    public synchronized void flush() {
        if (this.buffer.length() > 0) {
            this.flushBuffer();
        }
    }

    public void close() {
        this.flush();
    }

    private void flushBuffer() {
        String string = this.buffer.toString();
        this.buffer.setLength(0);
        SwingUtilities.invokeLater(new ConsoleWrite(this.textArea, string));
    }
}

